/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.win;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.algebricks.runtime.operators.win.WindowPartitionReader;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.io.GeneratedRunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;

final class WindowPartitionWriter {
    private final IHyracksTaskContext ctx;
    private final String fileNamePrefix;
    private final SourceLocation sourceLoc;
    private final IFrame[] writerFrames;
    private int writerFrameCount;
    private long writerFirstFrameId;
    private long writerLastFrameId;
    private RunFileWriter fileWriter;
    private final AbstractWindowPartitionReader partitionReader;

    WindowPartitionWriter(IHyracksTaskContext ctx, int memSizeInFrames, String fileNamePrefix, int readerPositionStoreSize, SourceLocation sourceLoc) throws HyracksDataException {
        this.ctx = ctx;
        this.fileNamePrefix = fileNamePrefix;
        this.sourceLoc = sourceLoc;
        this.partitionReader = readerPositionStoreSize < 1 ? new WindowPartitionForwardReader() : new WindowPartitionSeekableReader(readerPositionStoreSize);
        int writerFrameBudget = memSizeInFrames - this.partitionReader.getReservedFrameCount();
        if (writerFrameBudget < 1) {
            throw new IllegalArgumentException(String.valueOf(memSizeInFrames));
        }
        this.writerFrames = new IFrame[writerFrameBudget];
        this.allocateFrames(this.writerFrames, 1);
        this.writerLastFrameId = -1L;
        this.writerFirstFrameId = -1L;
    }

    void close() throws HyracksDataException {
        try {
            this.partitionReader.closeFileReader();
        }
        finally {
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
        }
    }

    void reset() {
        this.writerFrameCount = 0;
        if (this.fileWriter != null) {
            this.fileWriter.rewind();
        }
    }

    void nextFrame(long frameId, ByteBuffer frameBuffer) throws HyracksDataException {
        if (frameId < 0L) {
            throw new IllegalArgumentException(String.valueOf(frameId));
        }
        if (this.writerFrameCount == 0) {
            if (this.writerFirstFrameId != frameId) {
                WindowPartitionWriter.copyToFrame(frameBuffer, this.writerFrames[0]);
                this.writerFirstFrameId = frameId;
            }
        } else if (this.writerFrameCount < this.writerFrames.length) {
            IFrame writerFrame = this.writerFrames[this.writerFrameCount];
            if (writerFrame == null) {
                this.writerFrames[this.writerFrameCount] = writerFrame = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
            }
            WindowPartitionWriter.copyToFrame(frameBuffer, writerFrame);
        } else {
            if (this.fileWriter == null) {
                FileReference file = this.ctx.createManagedWorkspaceFile(this.fileNamePrefix);
                this.fileWriter = new RunFileWriter(file, this.ctx.getIoManager());
                this.fileWriter.open();
            }
            int pos = frameBuffer.position();
            frameBuffer.position(0);
            this.fileWriter.nextFrame(frameBuffer);
            frameBuffer.position(pos);
        }
        this.writerLastFrameId = frameId;
        ++this.writerFrameCount;
    }

    WindowPartitionReader getReader() {
        return this.partitionReader;
    }

    private void allocateFrames(IFrame[] outFrames, int count) throws HyracksDataException {
        for (int i = 0; i < count; ++i) {
            outFrames[i] = new VSizeFrame((IHyracksFrameMgrContext)this.ctx);
        }
    }

    private static void copyToFrame(ByteBuffer fromBuffer, IFrame toFrame) throws HyracksDataException {
        toFrame.ensureFrameSize(fromBuffer.capacity());
        int fromPosition = fromBuffer.position();
        FrameUtils.copyAndFlip((ByteBuffer)fromBuffer, (ByteBuffer)toFrame.getBuffer());
        fromBuffer.position(fromPosition);
    }

    private static <T> void swap(T[] array1, int index1, T[] array2, int index2) {
        T item1 = array1[index1];
        array1[index1] = array2[index2];
        array2[index2] = item1;
    }

    private final class WindowPartitionSeekableReader
    extends AbstractWindowPartitionReader {
        private final IFrame[] fileFrames;
        private final long[] fileFrameIdxs;
        private final long[] fileFrameSizes;
        private final long[] filePositionStore;
        private final int[] readerFrameIdxStore;

        private WindowPartitionSeekableReader(int positionStoreSize) throws HyracksDataException {
            this.fileFrames = new IFrame[2];
            WindowPartitionWriter.this.allocateFrames(this.fileFrames, this.fileFrames.length);
            this.fileFrameIdxs = new long[this.fileFrames.length];
            this.fileFrameSizes = new long[this.fileFrames.length];
            this.filePositionStore = new long[positionStoreSize];
            this.readerFrameIdxStore = new int[positionStoreSize];
        }

        @Override
        public void open() throws HyracksDataException {
            super.open();
            Arrays.fill(this.fileFrameIdxs, -1L);
            Arrays.fill(this.filePositionStore, -1L);
            Arrays.fill(this.readerFrameIdxStore, -1);
        }

        @Override
        IFrame nextFrameImpl(boolean primaryScan) throws HyracksDataException {
            if (this.readerFrameIdx < WindowPartitionWriter.this.writerFrames.length) {
                return WindowPartitionWriter.this.writerFrames[this.readerFrameIdx];
            }
            int fileFrameSlot = primaryScan ? 0 : 1;
            IFrame fileFrameRef = this.fileFrames[fileFrameSlot];
            long filePosition = this.fileReader.position();
            if ((long)this.readerFrameIdx == this.fileFrameIdxs[fileFrameSlot]) {
                this.fileReader.seek(filePosition + this.fileFrameSizes[fileFrameSlot]);
            } else {
                this.readFromFileReader(fileFrameRef);
                this.fileFrameSizes[fileFrameSlot] = this.fileReader.position() - filePosition;
                this.fileFrameIdxs[fileFrameSlot] = this.readerFrameIdx;
            }
            return fileFrameRef;
        }

        @Override
        public void closeImpl() {
            int endFrameIdx = this.readerFrameIdx - 1;
            if (endFrameIdx >= WindowPartitionWriter.this.writerFrames.length) {
                WindowPartitionWriter.swap(WindowPartitionWriter.this.writerFrames, 0, this.fileFrames, 0);
            } else if (endFrameIdx > 0) {
                WindowPartitionWriter.swap(WindowPartitionWriter.this.writerFrames, 0, WindowPartitionWriter.this.writerFrames, endFrameIdx);
            }
        }

        @Override
        public void savePosition(int slotNo) {
            this.readerFrameIdxStore[slotNo] = this.readerFrameIdx;
            this.filePositionStore[slotNo] = this.fileReader != null ? this.fileReader.position() : 0L;
        }

        @Override
        public void copyPosition(int slotFrom, int slotTo) {
            this.readerFrameIdxStore[slotTo] = this.readerFrameIdxStore[slotFrom];
            this.filePositionStore[slotTo] = this.filePositionStore[slotFrom];
        }

        @Override
        public void restorePosition(int slotNo) {
            this.seek(this.readerFrameIdxStore[slotNo], this.filePositionStore[slotNo]);
        }

        @Override
        public void rewind() {
            this.seek(0, 0L);
        }

        private void seek(int readerFrameIdx, long filePosition) {
            this.readerFrameIdx = readerFrameIdx;
            if (this.fileReader != null) {
                this.fileReader.seek(filePosition);
            }
        }

        @Override
        int getReservedFrameCount() {
            return this.fileFrames.length;
        }
    }

    private final class WindowPartitionForwardReader
    extends AbstractWindowPartitionReader {
        private WindowPartitionForwardReader() {
        }

        @Override
        IFrame nextFrameImpl(boolean primaryScan) throws HyracksDataException {
            if (!primaryScan) {
                throw new IllegalArgumentException();
            }
            if (this.readerFrameIdx < WindowPartitionWriter.this.writerFrames.length) {
                return WindowPartitionWriter.this.writerFrames[this.readerFrameIdx];
            }
            IFrame writerFrame0 = WindowPartitionWriter.this.writerFrames[0];
            this.readFromFileReader(writerFrame0);
            return writerFrame0;
        }

        @Override
        void closeImpl() {
            int endFrameIdx = this.readerFrameIdx - 1;
            if (endFrameIdx > 0 && endFrameIdx < WindowPartitionWriter.this.writerFrames.length) {
                WindowPartitionWriter.swap(WindowPartitionWriter.this.writerFrames, 0, WindowPartitionWriter.this.writerFrames, endFrameIdx);
            }
        }

        @Override
        public void savePosition(int slotNo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void copyPosition(int slotFrom, int slotTo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void restorePosition(int slotNo) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rewind() {
            throw new UnsupportedOperationException();
        }

        @Override
        int getReservedFrameCount() {
            return 0;
        }
    }

    private abstract class AbstractWindowPartitionReader
    implements WindowPartitionReader {
        int readerFrameIdx = -1;
        GeneratedRunFileReader fileReader;

        private AbstractWindowPartitionReader() {
        }

        @Override
        public void open() throws HyracksDataException {
            if (this.readerFrameIdx >= 0) {
                throw new IllegalStateException(String.valueOf(this.readerFrameIdx));
            }
            this.readerFrameIdx = 0;
            if (WindowPartitionWriter.this.writerFrameCount > WindowPartitionWriter.this.writerFrames.length) {
                this.openFileReader();
            }
        }

        @Override
        public final void close() throws HyracksDataException {
            if (this.readerFrameIdx != WindowPartitionWriter.this.writerFrameCount) {
                throw new IllegalStateException();
            }
            this.closeImpl();
            WindowPartitionWriter.this.writerFirstFrameId = WindowPartitionWriter.this.writerLastFrameId;
            this.readerFrameIdx = -1;
            if (WindowPartitionWriter.this.writerFrameCount > WindowPartitionWriter.this.writerFrames.length) {
                this.closeFileReader();
            }
        }

        void openFileReader() throws HyracksDataException {
            if (this.fileReader != null) {
                throw new IllegalStateException();
            }
            this.fileReader = WindowPartitionWriter.this.fileWriter.createReader();
            this.fileReader.open();
        }

        void closeFileReader() throws HyracksDataException {
            GeneratedRunFileReader r = this.fileReader;
            if (r != null) {
                this.fileReader = null;
                r.close();
            }
        }

        void readFromFileReader(IFrame outFrame) throws HyracksDataException {
            if (!this.fileReader.nextFrame(outFrame)) {
                throw HyracksDataException.create((int)120, (SourceLocation)WindowPartitionWriter.this.sourceLoc, (Serializable[])new Serializable[0]);
            }
        }

        @Override
        public final IFrame nextFrame(boolean primaryScan) throws HyracksDataException {
            if (this.readerFrameIdx < 0) {
                throw new IllegalStateException();
            }
            if (this.readerFrameIdx >= WindowPartitionWriter.this.writerFrameCount) {
                throw HyracksDataException.create((int)120, (SourceLocation)WindowPartitionWriter.this.sourceLoc, (Serializable[])new Serializable[0]);
            }
            IFrame frame = this.nextFrameImpl(primaryScan);
            ++this.readerFrameIdx;
            return frame;
        }

        abstract void closeImpl() throws HyracksDataException;

        abstract IFrame nextFrameImpl(boolean var1) throws HyracksDataException;

        abstract int getReservedFrameCount();
    }
}

