/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.rewriter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.ActivityCluster;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.rewriter.runtime.SuperActivity;

public class ActivityClusterGraphRewriter {
    private static final String ONE_TO_ONE_CONNECTOR = "org.apache.hyracks.dataflow.std.connectors.OneToOneConnectorDescriptor";

    public void rewrite(ActivityClusterGraph acg) {
        acg.getActivityMap().clear();
        acg.getConnectorMap().clear();
        HashMap invertedActivitySuperActivityMap = new HashMap();
        acg.getActivityClusterMap().forEach((key, value) -> this.rewriteIntraActivityCluster((ActivityCluster)value, invertedActivitySuperActivityMap));
        acg.getActivityClusterMap().forEach((key, value) -> this.rewriteInterActivityCluster((ActivityCluster)value, invertedActivitySuperActivityMap));
        invertedActivitySuperActivityMap.clear();
    }

    private void rewriteInterActivityCluster(ActivityCluster ac, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap) {
        Map<ActivityId, Set<ActivityId>> blocked2BlockerMap = ac.getBlocked2BlockerMap();
        HashMap invertedAid2SuperAidMap = new HashMap();
        invertedActivitySuperActivityMap.forEach((key, value) -> invertedAid2SuperAidMap.put(key.getActivityId(), value.getActivityId()));
        HashMap replacedBlocked2BlockerMap = new HashMap();
        blocked2BlockerMap.forEach((blocked, blockers) -> {
            ActivityId replacedBlocked = (ActivityId)invertedAid2SuperAidMap.get(blocked);
            HashSet replacedBlockers = null;
            if (blockers != null) {
                replacedBlockers = new HashSet();
                for (ActivityId blocker : blockers) {
                    replacedBlockers.add(invertedAid2SuperAidMap.get(blocker));
                    ActivityCluster dependingAc = ac.getActivityClusterGraph().getActivityMap().get(invertedAid2SuperAidMap.get(blocker));
                    if (ac.getDependencies().contains(dependingAc)) continue;
                    ac.getDependencies().add(dependingAc);
                }
            }
            if (replacedBlockers != null) {
                Set existingBlockers = (Set)replacedBlocked2BlockerMap.get(replacedBlocked);
                if (existingBlockers == null) {
                    replacedBlocked2BlockerMap.put(replacedBlocked, replacedBlockers);
                } else {
                    existingBlockers.addAll(replacedBlockers);
                    replacedBlocked2BlockerMap.put(replacedBlocked, existingBlockers);
                }
            }
        });
        blocked2BlockerMap.clear();
        blocked2BlockerMap.putAll(replacedBlocked2BlockerMap);
    }

    private void rewriteIntraActivityCluster(ActivityCluster ac, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap) {
        Map<ActivityId, IActivity> activities = ac.getActivityMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityInputMap = ac.getActivityInputMap();
        Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap = ac.getActivityOutputMap();
        Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> connectorActivityMap = ac.getConnectorActivityMap();
        ActivityClusterGraph acg = ac.getActivityClusterGraph();
        HashMap startActivities = new HashMap();
        HashMap<ActivityId, SuperActivity> superActivities = new HashMap<ActivityId, SuperActivity>();
        HashMap<ActivityId, Queue<IActivity>> toBeExpendedMap = new HashMap<ActivityId, Queue<IActivity>>();
        activities.forEach((activityId, activity) -> {
            if (activityInputMap.get(activityId) == null) {
                startActivities.put(activityId, activity);
                this.createNewSuperActivity(ac, (Map<ActivityId, SuperActivity>)superActivities, (Map<ActivityId, Queue<IActivity>>)toBeExpendedMap, invertedActivitySuperActivityMap, (ActivityId)activityId, (IActivity)activity);
            }
        });
        HashMap<ActivityId, SuperActivity> clonedSuperActivities = new HashMap<ActivityId, SuperActivity>();
        while (toBeExpendedMap.size() > 0) {
            clonedSuperActivities.clear();
            clonedSuperActivities.putAll(superActivities);
            for (Map.Entry entry : clonedSuperActivities.entrySet()) {
                Queue toBeExpended;
                ActivityId superActivityId = (ActivityId)entry.getKey();
                SuperActivity superActivity = (SuperActivity)entry.getValue();
                if (superActivities.get(superActivityId) == null || (toBeExpended = (Queue)toBeExpendedMap.get(superActivityId)) == null) continue;
                IActivity expendingActivity = (IActivity)toBeExpended.poll();
                List<IConnectorDescriptor> outputConnectors = activityOutputMap.get(expendingActivity.getActivityId());
                if (outputConnectors != null) {
                    for (IConnectorDescriptor outputConn : outputConnectors) {
                        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> endPoints2 = connectorActivityMap.get(outputConn.getConnectorId());
                        IActivity newActivity = (IActivity)((Pair)endPoints2.getRight()).getLeft();
                        SuperActivity existingSuperActivity = invertedActivitySuperActivityMap.get(newActivity);
                        if (outputConn.getClass().getName().contains(ONE_TO_ONE_CONNECTOR)) {
                            if (existingSuperActivity == null) {
                                superActivity.addActivity(newActivity);
                                toBeExpended.add(newActivity);
                                invertedActivitySuperActivityMap.put(newActivity, superActivity);
                                continue;
                            }
                            if (existingSuperActivity == superActivity) continue;
                            this.swallowExistingSuperActivity(superActivities, toBeExpendedMap, invertedActivitySuperActivityMap, superActivity, superActivityId, existingSuperActivity);
                            continue;
                        }
                        if (existingSuperActivity != null) continue;
                        this.createNewSuperActivity(ac, superActivities, toBeExpendedMap, invertedActivitySuperActivityMap, newActivity.getActivityId(), newActivity);
                    }
                }
                if (!toBeExpended.isEmpty()) continue;
                toBeExpendedMap.remove(superActivityId);
            }
        }
        Map<ConnectorDescriptorId, IConnectorDescriptor> connMap = ac.getConnectorMap();
        Map<ConnectorDescriptorId, RecordDescriptor> connRecordDesc = ac.getConnectorRecordDescriptorMap();
        HashMap superActivityProducerPort = new HashMap();
        HashMap superActivityConsumerPort = new HashMap();
        superActivities.forEach((key, value) -> {
            superActivityProducerPort.put(value, 0);
            superActivityConsumerPort.put(value, 0);
        });
        ActivityCluster newActivityCluster = new ActivityCluster(acg, ac.getId());
        newActivityCluster.setConnectorPolicyAssignmentPolicy(ac.getConnectorPolicyAssignmentPolicy());
        superActivities.forEach((key, value) -> {
            newActivityCluster.addActivity((IActivity)value);
            acg.getActivityMap().put((ActivityId)key, newActivityCluster);
        });
        connectorActivityMap.forEach((connectorId, endPoints) -> {
            IActivity producerActivity = (IActivity)((Pair)endPoints.getLeft()).getLeft();
            IActivity consumerActivity = (IActivity)((Pair)endPoints.getRight()).getLeft();
            int producerPort = (Integer)((Pair)endPoints.getLeft()).getRight();
            int consumerPort = (Integer)((Pair)endPoints.getRight()).getRight();
            RecordDescriptor recordDescriptor = (RecordDescriptor)connRecordDesc.get(connectorId);
            IConnectorDescriptor conn = (IConnectorDescriptor)connMap.get(connectorId);
            if (conn.getClass().getName().contains(ONE_TO_ONE_CONNECTOR)) {
                SuperActivity residingSuperActivity = (SuperActivity)invertedActivitySuperActivityMap.get(producerActivity);
                residingSuperActivity.connect(conn, producerActivity, producerPort, consumerActivity, consumerPort, recordDescriptor);
            } else {
                SuperActivity producerSuperActivity = (SuperActivity)invertedActivitySuperActivityMap.get(producerActivity);
                SuperActivity consumerSuperActivity = (SuperActivity)invertedActivitySuperActivityMap.get(consumerActivity);
                int producerSAPort = (Integer)superActivityProducerPort.get(producerSuperActivity);
                int consumerSAPort = (Integer)superActivityConsumerPort.get(consumerSuperActivity);
                newActivityCluster.addConnector(conn);
                newActivityCluster.connect(conn, producerSuperActivity, producerSAPort, consumerSuperActivity, consumerSAPort, recordDescriptor);
                producerSuperActivity.setClusterOutputIndex(producerSAPort, producerActivity.getActivityId(), producerPort);
                consumerSuperActivity.setClusterInputIndex(consumerSAPort, consumerActivity.getActivityId(), consumerPort);
                acg.getConnectorMap().put((ConnectorDescriptorId)connectorId, newActivityCluster);
                superActivityProducerPort.put(producerSuperActivity, ++producerSAPort);
                superActivityConsumerPort.put(consumerSuperActivity, ++consumerSAPort);
            }
        });
        superActivities.forEach((key, value) -> {
            List<IConnectorDescriptor> connIds = newActivityCluster.getActivityOutputMap().get(key);
            if (connIds == null || connIds.isEmpty()) {
                newActivityCluster.addRoot((IActivity)value);
            }
        });
        newActivityCluster.getBlocked2BlockerMap().putAll(ac.getBlocked2BlockerMap());
        acg.getActivityClusterMap().put(ac.getId(), newActivityCluster);
    }

    private void createNewSuperActivity(ActivityCluster acg, Map<ActivityId, SuperActivity> superActivities, Map<ActivityId, Queue<IActivity>> toBeExpendedMap, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap, ActivityId activityId, IActivity activity) {
        SuperActivity superActivity = new SuperActivity(acg.getActivityClusterGraph(), acg.getId(), activityId);
        superActivities.put(activityId, superActivity);
        superActivity.addActivity(activity);
        LinkedList<IActivity> toBeExpended = new LinkedList<IActivity>();
        toBeExpended.add(activity);
        toBeExpendedMap.put(activityId, toBeExpended);
        invertedActivitySuperActivityMap.put(activity, superActivity);
    }

    private void swallowExistingSuperActivity(Map<ActivityId, SuperActivity> superActivities, Map<ActivityId, Queue<IActivity>> toBeExpendedMap, Map<IActivity, SuperActivity> invertedActivitySuperActivityMap, SuperActivity superActivity, ActivityId superActivityId, SuperActivity existingSuperActivity) {
        ActivityId existingSuperActivityId = existingSuperActivity.getActivityId();
        superActivities.remove(existingSuperActivityId);
        for (Map.Entry<ActivityId, IActivity> existingEntry : existingSuperActivity.getActivityMap().entrySet()) {
            IActivity existingActivity = existingEntry.getValue();
            superActivity.addActivity(existingActivity);
            invertedActivitySuperActivityMap.put(existingActivity, superActivity);
        }
        Queue<IActivity> tbeQueue = toBeExpendedMap.get(superActivityId);
        Queue<IActivity> existingTbeQueque = toBeExpendedMap.remove(existingSuperActivityId);
        if (existingTbeQueque != null) {
            tbeQueue.addAll(existingTbeQueque);
        }
    }
}

