/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules.subplan;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.plan.ALogicalPlanImpl;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class PushSubplanIntoGroupByRule
implements IAlgebraicRewriteRule {
    private Mutable<ILogicalOperator> rootRef;
    private boolean invoked = false;

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (!this.invoked) {
            this.rootRef = opRef;
            this.invoked = true;
        }
        return this.rewriteForOperator(this.rootRef, (ILogicalOperator)opRef.getValue(), context);
    }

    private boolean rewriteForOperator(Mutable<ILogicalOperator> rootRef, ILogicalOperator parentOperator, IOptimizationContext context) throws AlgebricksException {
        boolean changed = false;
        List parentInputs = parentOperator.getInputs();
        int n = parentInputs.size();
        for (int i = 0; i < n; ++i) {
            SubplanOperator destOp;
            Mutable ref = (Mutable)parentInputs.get(i);
            ILogicalOperator op = (ILogicalOperator)ref.getValue();
            if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) {
                changed |= this.rewriteForOperator(rootRef, op, context);
                continue;
            }
            ArrayDeque<SubplanOperator> subplans = new ArrayDeque<SubplanOperator>();
            while (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN) {
                SubplanOperator currentSubplan = (SubplanOperator)op;
                for (ILogicalPlan subplan : currentSubplan.getNestedPlans()) {
                    for (Mutable nestedRootRef : subplan.getRoots()) {
                        changed |= this.rewriteForOperator((Mutable<ILogicalOperator>)nestedRootRef, (ILogicalOperator)nestedRootRef.getValue(), context);
                    }
                }
                subplans.addFirst(currentSubplan);
                op = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
            }
            if (op.getOperatorTag() == LogicalOperatorTag.GROUP) {
                GroupByOperator gby = (GroupByOperator)op;
                for (ILogicalPlan gbyNestedPlan : gby.getNestedPlans()) {
                    for (Mutable gbyNestedPlanRootRef : gbyNestedPlan.getRoots()) {
                        changed |= this.rewriteForOperator((Mutable<ILogicalOperator>)gbyNestedPlanRootRef, (ILogicalOperator)gbyNestedPlanRootRef.getValue(), context);
                    }
                }
                changed |= this.pushSubplansIntoGroupByOrSubplan(rootRef, parentOperator, i, subplans, (AbstractOperatorWithNestedPlans)gby, context);
                continue;
            }
            if (subplans.size() <= 1 || !context.getPhysicalOptimizationConfig().getSubplanMerge() || context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)(destOp = (SubplanOperator)subplans.removeFirst()))) continue;
            changed |= this.pushSubplansIntoGroupByOrSubplan(rootRef, parentOperator, i, subplans, (AbstractOperatorWithNestedPlans)destOp, context);
        }
        return changed;
    }

    private boolean pushSubplansIntoGroupByOrSubplan(Mutable<ILogicalOperator> currentRootRef, ILogicalOperator parentOperator, int parentChildIdx, Deque<SubplanOperator> subplans, AbstractOperatorWithNestedPlans destOp, IOptimizationContext context) throws AlgebricksException {
        int childIdx;
        ILogicalOperator parent;
        boolean changed = false;
        ArrayList<ALogicalPlanImpl> newDestOpNestedPlans = new ArrayList<ALogicalPlanImpl>();
        ArrayDeque<ListSet> freeVarsInSubplans = new ArrayDeque<ListSet>(subplans.size());
        for (SubplanOperator subplan : subplans) {
            ListSet freeVarsInSubplan = new ListSet();
            OperatorPropertiesUtil.getFreeVariablesInSubplans((AbstractOperatorWithNestedPlans)subplan, (Set)freeVarsInSubplan);
            freeVarsInSubplans.addLast(freeVarsInSubplan);
        }
        ListSet liveVarsBeforeDestOp = new ListSet();
        ILogicalOperator destOpInput = (ILogicalOperator)((Mutable)destOp.getInputs().get(0)).getValue();
        VariableUtilities.getLiveVariables((ILogicalOperator)destOpInput, (Collection)liveVarsBeforeDestOp);
        ListSet liveVarsInDestOpNestedPlan = new ListSet();
        ListSet upperSubplanFreeVarsTmp = new ListSet();
        Iterator<SubplanOperator> subplanOperatorIterator = subplans.iterator();
        while (subplanOperatorIterator.hasNext()) {
            SubplanOperator upperSubplan = subplanOperatorIterator.next();
            Set upperSubplanFreeVars = (Set)freeVarsInSubplans.removeFirst();
            Iterator upperSubplanNestedPlanIter = upperSubplan.getNestedPlans().iterator();
            while (upperSubplanNestedPlanIter.hasNext()) {
                ILogicalPlan upperSubplanNestedPlan = (ILogicalPlan)upperSubplanNestedPlanIter.next();
                List upperSubplanRootRefs = upperSubplanNestedPlan.getRoots();
                Iterator upperSubplanRootRefIter = upperSubplanRootRefs.iterator();
                block3: while (upperSubplanRootRefIter.hasNext()) {
                    Mutable upperSubplanRootRef = (Mutable)upperSubplanRootRefIter.next();
                    Mutable<ILogicalOperator> upperSubplanNtsRef = this.downToNts((Mutable<ILogicalOperator>)upperSubplanRootRef);
                    if (upperSubplanNtsRef == null) continue;
                    for (ILogicalPlan originalDestOpNestedPlan : destOp.getNestedPlans()) {
                        for (Mutable originalDestOpNestedPlanRootRef : originalDestOpNestedPlan.getRoots()) {
                            boolean nestedPlanShapeOk;
                            boolean bl = nestedPlanShapeOk = ((ILogicalOperator)originalDestOpNestedPlanRootRef.getValue()).getOperatorTag() == LogicalOperatorTag.AGGREGATE && this.downToNts((Mutable<ILogicalOperator>)originalDestOpNestedPlanRootRef) != null;
                            if (!nestedPlanShapeOk) continue;
                            upperSubplanFreeVarsTmp.clear();
                            upperSubplanFreeVarsTmp.addAll(upperSubplanFreeVars);
                            liveVarsInDestOpNestedPlan.clear();
                            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)originalDestOpNestedPlanRootRef.getValue()), (Collection)liveVarsInDestOpNestedPlan);
                            if (!upperSubplanFreeVarsTmp.removeAll((Collection<?>)liveVarsInDestOpNestedPlan)) continue;
                            boolean needInnerSubplan = false;
                            if (!upperSubplanFreeVarsTmp.isEmpty()) {
                                if (!context.getPhysicalOptimizationConfig().getSubplanNestedPushdown()) continue;
                                upperSubplanFreeVarsTmp.removeAll((Collection<?>)liveVarsBeforeDestOp);
                                if (!upperSubplanFreeVarsTmp.isEmpty()) continue;
                                needInnerSubplan = true;
                            }
                            Pair copiedDestOpNestedPlanRootRefAndVarMap = OperatorManipulationUtil.deepCopyWithNewVars((ILogicalOperator)((ILogicalOperator)originalDestOpNestedPlanRootRef.getValue()), (IOptimizationContext)context, (boolean)false);
                            ILogicalOperator copiedDestOpNestedPlanRootRef = (ILogicalOperator)copiedDestOpNestedPlanRootRefAndVarMap.first;
                            AggregateOperator originalAggOp = (AggregateOperator)originalDestOpNestedPlanRootRef.getValue();
                            AggregateOperator copiedAggOp = (AggregateOperator)copiedDestOpNestedPlanRootRef;
                            for (int varIndex = originalAggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                                if (upperSubplanFreeVars.contains(originalAggOp.getVariables().get(varIndex))) continue;
                                copiedAggOp.getVariables().remove(varIndex);
                                copiedAggOp.getExpressions().remove(varIndex);
                            }
                            ILogicalOperator upperSubplanRoot = (ILogicalOperator)upperSubplanRootRef.getValue();
                            VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)upperSubplanRoot, (Map)((Map)copiedDestOpNestedPlanRootRefAndVarMap.second), (ITypingContext)context);
                            Mutable<ILogicalOperator> copiedDestOpNestedPlanNtsRef = Objects.requireNonNull(this.downToNts((Mutable<ILogicalOperator>)new MutableObject((Object)copiedDestOpNestedPlanRootRef)));
                            NestedTupleSourceOperator copiedDestOpNestedPlanNts = (NestedTupleSourceOperator)copiedDestOpNestedPlanNtsRef.getValue();
                            if (needInnerSubplan) {
                                SubplanOperator newInnerSubplan = new SubplanOperator(copiedDestOpNestedPlanRootRef);
                                NestedTupleSourceOperator newNts = new NestedTupleSourceOperator((Mutable)new MutableObject((Object)destOp));
                                newInnerSubplan.getInputs().add(new MutableObject((Object)newNts));
                                copiedDestOpNestedPlanNts.setDataSourceReference((Mutable)new MutableObject((Object)newInnerSubplan));
                                upperSubplanNtsRef.setValue((Object)newInnerSubplan);
                            } else {
                                copiedDestOpNestedPlanNts.setDataSourceReference((Mutable)new MutableObject((Object)destOp));
                                upperSubplanNtsRef.setValue((Object)copiedDestOpNestedPlanRootRef);
                            }
                            newDestOpNestedPlans.add(new ALogicalPlanImpl((Mutable)new MutableObject((Object)upperSubplanRoot)));
                            upperSubplanRootRefIter.remove();
                            changed = true;
                            continue block3;
                        }
                    }
                }
                if (!upperSubplanRootRefs.isEmpty()) continue;
                upperSubplanNestedPlanIter.remove();
                changed = true;
            }
            if (!upperSubplan.getNestedPlans().isEmpty()) continue;
            subplanOperatorIterator.remove();
            changed = true;
        }
        if (!changed) {
            return false;
        }
        if (!subplans.isEmpty()) {
            parent = (ILogicalOperator)subplans.getFirst();
            childIdx = 0;
        } else {
            parent = parentOperator;
            childIdx = parentChildIdx;
        }
        ((Mutable)parent.getInputs().get(childIdx)).setValue((Object)destOp);
        destOp.getNestedPlans().addAll(newDestOpNestedPlans);
        this.cleanup((ILogicalOperator)currentRootRef.getValue(), destOp);
        if (destOp.getOperatorTag() == LogicalOperatorTag.SUBPLAN && destOp.getNumberOfRoots() > 1) {
            this.splitMultiRootSubplan((SubplanOperator)destOp, context);
        }
        for (ILogicalPlan nestedPlan : destOp.getNestedPlans()) {
            for (Mutable rootOp : nestedPlan.getRoots()) {
                OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)((ILogicalOperator)rootOp.getValue()), (ITypingContext)context);
            }
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)destOp);
        context.computeAndSetTypeEnvironmentForOperator(parent);
        return true;
    }

    private void cleanup(ILogicalOperator rootOp, AbstractOperatorWithNestedPlans destOp) throws AlgebricksException {
        HashSet freeVars = new HashSet();
        OperatorPropertiesUtil.getFreeVariablesInPath((ILogicalOperator)rootOp, (ILogicalOperator)destOp, freeVars);
        Iterator nestedPlanIter = destOp.getNestedPlans().iterator();
        while (nestedPlanIter.hasNext()) {
            ILogicalPlan nestedPlan = (ILogicalPlan)nestedPlanIter.next();
            Iterator nestRootRefIterator = nestedPlan.getRoots().iterator();
            while (nestRootRefIterator.hasNext()) {
                Mutable nestRootRef = (Mutable)nestRootRefIterator.next();
                AggregateOperator aggOp = (AggregateOperator)nestRootRef.getValue();
                for (int varIndex = aggOp.getVariables().size() - 1; varIndex >= 0; --varIndex) {
                    if (freeVars.contains(aggOp.getVariables().get(varIndex))) continue;
                    aggOp.getVariables().remove(varIndex);
                    aggOp.getExpressions().remove(varIndex);
                }
                if (!aggOp.getVariables().isEmpty()) continue;
                nestRootRefIterator.remove();
            }
            if (!nestedPlan.getRoots().isEmpty()) continue;
            nestedPlanIter.remove();
        }
    }

    private void splitMultiRootSubplan(SubplanOperator destOp, IOptimizationContext context) throws AlgebricksException {
        ILogicalOperator destOpRoot;
        ILogicalOperator currentInputOp = (ILogicalOperator)((Mutable)destOp.getInputs().get(0)).getValue();
        LinkedList destOpRootRefs = destOp.allRootsInReverseOrder();
        while (true) {
            Mutable destOpRootRef = (Mutable)destOpRootRefs.removeFirst();
            destOpRoot = (ILogicalOperator)destOpRootRef.getValue();
            if (destOpRootRefs.isEmpty()) break;
            SubplanOperator newSubplanOp = new SubplanOperator(destOpRoot);
            newSubplanOp.setSourceLocation(destOp.getSourceLocation());
            newSubplanOp.getInputs().add(new MutableObject((Object)currentInputOp));
            Mutable<ILogicalOperator> ntsRef = this.downToNts((Mutable<ILogicalOperator>)destOpRootRef);
            if (ntsRef == null) {
                throw AlgebricksException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (SourceLocation)destOpRoot.getSourceLocation(), (Serializable[])new Serializable[]{""});
            }
            ((NestedTupleSourceOperator)ntsRef.getValue()).getDataSourceReference().setValue((Object)newSubplanOp);
            OperatorManipulationUtil.computeTypeEnvironmentBottomUp((ILogicalOperator)destOpRoot, (ITypingContext)context);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newSubplanOp);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)newSubplanOp);
            currentInputOp = newSubplanOp;
        }
        destOp.getNestedPlans().clear();
        destOp.getNestedPlans().add(new ALogicalPlanImpl((Mutable)new MutableObject((Object)destOpRoot)));
        destOp.getInputs().clear();
        destOp.getInputs().add(new MutableObject((Object)currentInputOp));
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)destOp);
    }

    private Mutable<ILogicalOperator> downToNts(Mutable<ILogicalOperator> opRef) {
        Mutable leafOp;
        List leafOps = OperatorManipulationUtil.findLeafDescendantsOrSelf(opRef);
        if (leafOps.size() == 1 && ((ILogicalOperator)(leafOp = (Mutable)leafOps.get(0)).getValue()).getOperatorTag() == LogicalOperatorTag.NESTEDTUPLESOURCE) {
            return leafOp;
        }
        return null;
    }
}

