/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.azure;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.ListBlobsOptions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.azure.AzureBlobInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;

public class AzureBlobInputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new AzureBlobInputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths());
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        super.configure(ctx, configuration, warningCollector);
        String container = configuration.get("container");
        ArrayList<BlobItem> filesOnly = new ArrayList<BlobItem>();
        ExternalDataUtils.validateIncludeExclude(configuration);
        BlobServiceClient blobServiceClient = ExternalDataUtils.Azure.buildAzureClient(configuration);
        try {
            BlobContainerClient blobContainer = blobServiceClient.getBlobContainerClient(container);
            ListBlobsOptions listBlobsOptions = new ListBlobsOptions();
            listBlobsOptions.setPrefix(ExternalDataUtils.getPrefix(configuration));
            PagedIterable blobItems = blobContainer.listBlobs(listBlobsOptions, null);
            AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = this.getIncludeExcludeMatchers();
            this.collectAndFilterFiles((Iterable<BlobItem>)blobItems, includeExcludeMatcher.getPredicate(), includeExcludeMatcher.getMatchersList(), filesOnly);
            if (filesOnly.isEmpty() && warningCollector.shouldWarn()) {
                Warning warning = Warning.of(null, (IError)ErrorCode.EXTERNAL_SOURCE_CONFIGURATION_RETURNED_NO_FILES, (Serializable[])new Serializable[0]);
                warningCollector.warn(warning);
            }
            this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
        }
        catch (Exception ex) {
            throw new CompilationException(ErrorCode.EXTERNAL_SOURCE_ERROR, new Serializable[]{ex.getMessage()});
        }
    }

    private void collectAndFilterFiles(Iterable<BlobItem> items, BiPredicate<List<Matcher>, String> predicate, List<Matcher> matchers, List<BlobItem> filesOnly) {
        for (BlobItem item : items) {
            String uri = item.getName();
            if (uri.endsWith("/") || !predicate.test(matchers, uri)) continue;
            filesOnly.add(item);
        }
    }

    private void distributeWorkLoad(List<BlobItem> items, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (BlobItem object : items) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(object.getName(), object.getProperties().getContentLength());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

