/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.serializer;

import java.io.PrintStream;
import java.nio.BufferOverflowException;
import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.IResultSerializerFactoryProvider;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.IResultSerializer;
import org.apache.hyracks.api.dataflow.value.IResultSerializerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ResultSerializerFactoryProvider
implements IResultSerializerFactoryProvider {
    private static final long serialVersionUID = 1L;
    public static final ResultSerializerFactoryProvider INSTANCE = new ResultSerializerFactoryProvider();

    private ResultSerializerFactoryProvider() {
    }

    public IResultSerializerFactory getAqlResultSerializerFactoryProvider(final int[] fields, final IPrinterFactory[] printerFactories, final IAWriterFactory writerFactory) {
        return new IResultSerializerFactory(){
            private static final long serialVersionUID = 1L;

            public IResultSerializer createResultSerializer(RecordDescriptor inputRecordDesc, PrintStream printStream) {
                final IAWriter writer = writerFactory.createWriter(fields, printStream, printerFactories, inputRecordDesc);
                return new IResultSerializer(){
                    private static final long serialVersionUID = 1L;

                    public void init() throws HyracksDataException {
                        writer.init();
                    }

                    public boolean appendTuple(IFrameTupleAccessor tAccess, int tIdx) throws HyracksDataException {
                        try {
                            writer.printTuple(tAccess, tIdx);
                        }
                        catch (BufferOverflowException e) {
                            return false;
                        }
                        return true;
                    }
                };
            }
        };
    }
}

