/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.transactions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.asterix.common.transactions.ILogManager;

public class TxnLogFile {
    private final FileChannel fileChannel;
    private final long logFileId;
    private final long fileBeginLSN;
    private final ILogManager logManager;
    private boolean open = true;

    public TxnLogFile(ILogManager logManager, FileChannel fileChannel, long logFileId, long fileBeginLSN) {
        this.logManager = logManager;
        this.fileChannel = fileChannel;
        this.logFileId = logFileId;
        this.fileBeginLSN = fileBeginLSN;
    }

    public void position(long newPosition) throws IOException {
        this.fileChannel.position(newPosition);
    }

    public long size() throws IOException {
        return this.fileChannel.size();
    }

    public int read(ByteBuffer readBuffer) throws IOException {
        return this.fileChannel.read(readBuffer);
    }

    public long getLogFileId() {
        return this.logFileId;
    }

    public synchronized void close() throws IOException {
        if (this.open) {
            this.logManager.closeLogFile(this, this.fileChannel);
            this.open = false;
        }
    }

    public long getFileBeginLSN() {
        return this.fileBeginLSN;
    }
}

