/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.Serializable;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class HyracksDataException
extends HyracksException {
    private static final long serialVersionUID = 1L;

    public static HyracksDataException create(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("Attempt to wrap null in a HyracksDataException");
        }
        if (cause instanceof HyracksDataException) {
            return (HyracksDataException)cause;
        }
        if (cause instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        return new HyracksDataException(cause);
    }

    public static HyracksDataException create(ErrorCode code, SourceLocation sourceLoc, Serializable ... params) {
        return new HyracksDataException(code, sourceLoc, params);
    }

    public static HyracksDataException create(ErrorCode code, Serializable ... params) {
        return new HyracksDataException(code, params);
    }

    public static HyracksDataException create(ErrorCode code, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        return new HyracksDataException(code, cause, sourceLoc, params);
    }

    public static HyracksDataException create(ErrorCode code, Throwable cause, Serializable ... params) {
        return new HyracksDataException(code, cause, null, params);
    }

    public static HyracksDataException create(HyracksDataException e, String nodeId) {
        return new HyracksDataException(e, nodeId);
    }

    @Deprecated
    public HyracksDataException(String message) {
        super(message);
    }

    protected HyracksDataException(Throwable cause) {
        super(cause);
    }

    @Deprecated
    public HyracksDataException(String message, Throwable cause) {
        super(message, cause);
    }

    public HyracksDataException(ErrorCode code, Serializable ... params) {
        this(code, (SourceLocation)null, params);
    }

    public HyracksDataException(ErrorCode code, SourceLocation sourceLoc, Serializable ... params) {
        this(code, (Throwable)null, sourceLoc, params);
    }

    public HyracksDataException(ErrorCode code, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        super((IError)code, code.component(), code.intValue(), code.errorMessage(), cause, sourceLoc, null, params);
    }

    private HyracksDataException(HyracksDataException hde, String nodeId) {
        super((IError)hde.getError().orElse(null), hde.getComponent(), hde.getErrorCode(), hde.getMessage(), hde.getCause(), hde.getSourceLocation(), nodeId, hde.getStackTrace(), hde.getParams());
    }

    protected HyracksDataException(IError error, Throwable cause, SourceLocation sourceLoc, Serializable ... params) {
        super(error, error.component(), error.intValue(), error.errorMessage(), cause, sourceLoc, null, params);
    }
}

