/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.jackson;

import java.io.IOException;
import java.util.BitSet;
import java.util.Map;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.ListBuilderFactory;
import org.apache.asterix.builders.RecordBuilderFactory;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.input.stream.StandardUTF8ToModifiedUTF8DataOutput;
import org.apache.asterix.external.parser.jackson.IObjectPool;
import org.apache.asterix.external.parser.jackson.ObjectPool;
import org.apache.asterix.external.parser.jackson.SoftObjectPool;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.string.UTF8StringReader;
import org.apache.hyracks.util.string.UTF8StringWriter;

public class ParserContext {
    private static final int SERIALIZED_FIELDNAME_MAP_MAX_SIZE = 128;
    private final IObjectPool<IARecordBuilder> objectBuilderPool = new SoftObjectPool(new RecordBuilderFactory());
    private final ObjectPool<IAsterixListBuilder, ATypeTag> arrayBuilderPool = new ObjectPool(new ListBuilderFactory(), ATypeTag.ARRAY);
    private final IObjectPool<IMutableValueStorage> tempBufferPool = new SoftObjectPool(new AbvsBuilderFactory());
    private final ObjectPool<BitSet, Void> nullBitmapPool = new ObjectPool();
    private final Map<String, IMutableValueStorage> serializedFieldNames = new LRUMap(128);
    private final ISerializerDeserializer<AString> stringSerDe = SerializerDeserializerProvider.INSTANCE.getAStringSerializerDeserializer();
    private final AMutableString aString = new AMutableString("");
    private final StandardUTF8ToModifiedUTF8DataOutput modifiedUTF8DataOutput;

    public ParserContext() {
        this(false);
    }

    public ParserContext(boolean allocateModfiedUTF8Writer) {
        this.modifiedUTF8DataOutput = allocateModfiedUTF8Writer ? new StandardUTF8ToModifiedUTF8DataOutput(new AStringSerializerDeserializer(new UTF8StringWriter(), new UTF8StringReader())) : null;
    }

    public IMutableValueStorage enterObject() {
        return this.tempBufferPool.getInstance();
    }

    public BitSet getNullBitmap(int size) {
        if (size < 1) {
            return null;
        }
        BitSet nullBitMap = (BitSet)this.nullBitmapPool.getInstance();
        if (nullBitMap == null) {
            nullBitMap = new BitSet(size);
        }
        return nullBitMap;
    }

    public IARecordBuilder getObjectBuilder(ARecordType recordType) {
        IARecordBuilder builder = this.objectBuilderPool.getInstance();
        builder.reset(recordType);
        return builder;
    }

    public IMutableValueStorage getSerializedFieldName(String fieldName) throws IOException {
        IMutableValueStorage serializedFieldName = this.serializedFieldNames.get(fieldName);
        if (serializedFieldName == null) {
            serializedFieldName = new ArrayBackedValueStorage();
            serializedFieldName.reset();
            this.aString.setValue(fieldName);
            this.stringSerDe.serialize((Object)this.aString, serializedFieldName.getDataOutput());
            this.serializedFieldNames.put(fieldName, serializedFieldName);
        }
        return serializedFieldName;
    }

    public void exitObject(IMutableValueStorage tempBuffer, BitSet nullBitmap, IARecordBuilder builder) {
        this.tempBufferPool.recycle(tempBuffer);
        this.objectBuilderPool.recycle(builder);
        if (nullBitmap != null) {
            nullBitmap.clear();
            this.nullBitmapPool.recycle(nullBitmap);
        }
    }

    public IMutableValueStorage enterCollection() {
        return this.tempBufferPool.getInstance();
    }

    public IAsterixListBuilder getCollectionBuilder(AbstractCollectionType collectionType) {
        IAsterixListBuilder builder = (IAsterixListBuilder)this.arrayBuilderPool.getInstance();
        builder.reset(collectionType);
        return builder;
    }

    public void exitCollection(IMutableValueStorage tempBuffer, IAsterixListBuilder builder) {
        this.tempBufferPool.recycle(tempBuffer);
        this.arrayBuilderPool.recycle(builder);
    }

    public StandardUTF8ToModifiedUTF8DataOutput getModifiedUTF8DataOutput() {
        return this.modifiedUTF8DataOutput;
    }
}

