/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.join;

import java.util.BitSet;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.IPartitionedTupleBufferManager;
import org.apache.hyracks.dataflow.std.join.OptimizedHybridHashJoin;

public class HybridHashJoinUtil {
    private HybridHashJoinUtil() {
    }

    public String printPartitionInfo(BitSet spilledStatus, OptimizedHybridHashJoin.SIDE whichSide, int numOfPartitions, int[] probePSizeInTups, int[] buildPSizeInTups, RunFileWriter[] probeRFWriters, RunFileWriter[] buildRFWriters, IPartitionedTupleBufferManager bufferManager) {
        StringBuilder buf = new StringBuilder();
        buf.append(">>> " + this + " " + Thread.currentThread().getId() + " printInfo():\n");
        if (whichSide == OptimizedHybridHashJoin.SIDE.BUILD) {
            buf.append("BUILD side\n");
        } else {
            buf.append("PROBE side\n");
        }
        buf.append("# of partitions:\t" + numOfPartitions + "\t#spilled:\t" + spilledStatus.cardinality() + "\t#in-memory:\t" + (numOfPartitions - spilledStatus.cardinality()) + "\n");
        buf.append("(A) Spilled partitions\n");
        int spilledTupleCount = 0;
        int spilledPartByteSize = 0;
        int pid = spilledStatus.nextSetBit(0);
        while (pid >= 0 && pid < numOfPartitions) {
            if (whichSide == OptimizedHybridHashJoin.SIDE.BUILD) {
                spilledTupleCount += buildPSizeInTups[pid];
                spilledPartByteSize = (int)((long)spilledPartByteSize + buildRFWriters[pid].getFileSize());
                buf.append("part:\t" + pid + "\t#tuple:\t" + buildPSizeInTups[pid] + "\tsize(MB):\t" + (double)buildRFWriters[pid].getFileSize() / 1048576.0 + "\n");
            } else {
                spilledTupleCount += probePSizeInTups[pid];
                spilledPartByteSize = (int)((long)spilledPartByteSize + probeRFWriters[pid].getFileSize());
            }
            pid = spilledStatus.nextSetBit(pid + 1);
        }
        if (spilledStatus.cardinality() > 0) {
            buf.append("# of spilled tuples:\t" + spilledTupleCount + "\tsize(MB):\t" + (double)spilledPartByteSize / 1048576.0 + "avg #tuples per spilled part:\t" + spilledTupleCount / spilledStatus.cardinality() + "\tavg size per part(MB):\t" + (double)spilledPartByteSize / 1048576.0 / (double)spilledStatus.cardinality() + "\n");
        }
        buf.append("(B) In-memory partitions\n");
        int inMemoryTupleCount = 0;
        int inMemoryPartByteSize = 0;
        int pid2 = spilledStatus.nextClearBit(0);
        while (pid2 >= 0 && pid2 < numOfPartitions) {
            if (whichSide == OptimizedHybridHashJoin.SIDE.BUILD) {
                inMemoryTupleCount += buildPSizeInTups[pid2];
                inMemoryPartByteSize += bufferManager.getPhysicalSize(pid2);
            } else {
                inMemoryTupleCount += probePSizeInTups[pid2];
                inMemoryPartByteSize += bufferManager.getPhysicalSize(pid2);
            }
            pid2 = spilledStatus.nextClearBit(pid2 + 1);
        }
        if (spilledStatus.cardinality() > 0) {
            buf.append("# of in-memory tuples:\t" + inMemoryTupleCount + "\tsize(MB):\t" + (double)inMemoryPartByteSize / 1048576.0 + "avg #tuples per spilled part:\t" + inMemoryTupleCount / spilledStatus.cardinality() + "\tavg size per part(MB):\t" + (double)inMemoryPartByteSize / 1048576.0 / (double)(numOfPartitions - spilledStatus.cardinality()) + "\n");
        }
        if (inMemoryTupleCount + spilledTupleCount > 0) {
            buf.append("# of all tuples:\t" + (inMemoryTupleCount + spilledTupleCount) + "\tsize(MB):\t" + (double)(inMemoryPartByteSize + spilledPartByteSize) / 1048576.0 + " ratio of spilled tuples:\t" + spilledTupleCount / (inMemoryTupleCount + spilledTupleCount) + "\n");
        } else {
            buf.append("# of all tuples:\t" + (inMemoryTupleCount + spilledTupleCount) + "\tsize(MB):\t" + (double)(inMemoryPartByteSize + spilledPartByteSize) / 1048576.0 + " ratio of spilled tuples:\tN/A\n");
        }
        return buf.toString();
    }
}

