/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;

public class TaggedValuePointable
extends AbstractPointable {
    public static final TaggedValuePointableFactory FACTORY = new TaggedValuePointableFactory();

    public byte getTag() {
        return BytePointable.getByte(this.bytes, this.start);
    }

    public void getValue(IPointable value) {
        value.set(this.bytes, this.start + 1, this.length - 1);
    }

    public static final class TaggedValuePointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private TaggedValuePointableFactory() {
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return VoidPointable.TYPE_TRAITS;
        }

        @Override
        public TaggedValuePointable createPointable() {
            return new TaggedValuePointable();
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

