/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.exceptions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IFormattedException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.util.ErrorMessageUtil;

public class HyracksException
extends IOException
implements IFormattedException {
    private static final long serialVersionUID = 2L;
    public static final int UNKNOWN = 0;
    private final String component;
    private final int errorCode;
    private final Serializable[] params;
    private final String nodeId;
    private SourceLocation sourceLoc;
    protected transient IError error;
    private volatile transient String msgCache;

    public static HyracksException create(Throwable cause) {
        if (cause instanceof HyracksException) {
            return (HyracksException)cause;
        }
        return new HyracksException(cause);
    }

    public static HyracksException wrapOrThrowUnchecked(Throwable cause) {
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof HyracksException) {
            return (HyracksException)cause;
        }
        return new HyracksException(cause);
    }

    public static HyracksException create(ErrorCode code, Serializable ... params) {
        return new HyracksException(code, params);
    }

    public static HyracksException create(ErrorCode code, Throwable cause, Serializable ... params) {
        return new HyracksException(code, cause, params);
    }

    @Deprecated
    public HyracksException(String message) {
        this(message, null);
    }

    protected HyracksException(IError error, String component, int intCode, String message, Throwable cause, SourceLocation sourceLoc, String nodeId, Serializable ... params) {
        super(message, cause);
        this.error = error;
        this.sourceLoc = sourceLoc;
        this.component = component;
        this.errorCode = intCode;
        this.nodeId = nodeId;
        this.params = params;
    }

    protected HyracksException(IError errorCode, Throwable cause, SourceLocation sourceLoc, String nodeId, Serializable ... params) {
        this(errorCode, errorCode.component(), errorCode.intValue(), errorCode.errorMessage(), cause, sourceLoc, nodeId, params);
    }

    @Deprecated
    protected HyracksException(Throwable cause) {
        this(String.valueOf(cause), cause);
    }

    @Deprecated
    protected HyracksException(String message, Throwable cause) {
        this("", 0, message, cause, new Serializable[0]);
    }

    public HyracksException(ErrorCode errorCode, Throwable cause, Serializable ... params) {
        this(errorCode.component(), errorCode.intValue(), errorCode.errorMessage(), cause, (String)null, params);
    }

    public HyracksException(ErrorCode errorCode, Serializable ... params) {
        this(errorCode.component(), errorCode.intValue(), errorCode.errorMessage(), (Throwable)null, (String)null, params);
    }

    private HyracksException(String component, int errorCode, String message, Throwable cause, Serializable ... params) {
        this(component, errorCode, message, cause, (String)null, params);
    }

    private HyracksException(String component, int errorCode, String message, Throwable cause, String nodeId, Serializable ... params) {
        this(null, component, errorCode, message, cause, null, nodeId, params);
    }

    @Override
    public String getComponent() {
        return this.component;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    public Serializable[] getParams() {
        return this.params;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLoc;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLoc = sourceLocation;
    }

    @Override
    public String getMessage() {
        String message = this.msgCache;
        if (message == null) {
            this.msgCache = message = ErrorMessageUtil.formatMessage(this.component, this.errorCode, super.getMessage(), this.sourceLoc, this.params);
        }
        return message;
    }

    @Override
    public String toString() {
        return this.getLocalizedMessage();
    }

    @Override
    public Optional<IError> getError() {
        return Optional.ofNullable(this.error);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ErrorMessageUtil.writeObjectWithError(this.error, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.error = ErrorMessageUtil.readObjectWithError(in).orElse(null);
    }
}

