/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.declared;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSourcePropertiesProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.RandomPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.UnorderedPartitionedProperty;

public class DataSourcePartitioningProvider
implements IDataSourcePropertiesProvider {
    private final DataSource ds;
    private final INodeDomain domain;

    public DataSourcePartitioningProvider(DataSource dataSource, INodeDomain domain) {
        this.ds = dataSource;
        this.domain = domain;
    }

    public IPhysicalPropertiesVector computePropertiesVector(List<LogicalVariable> scanVariables) {
        RandomPartitioningProperty pp;
        ArrayList<ILocalStructuralProperty> propsLocal = new ArrayList<ILocalStructuralProperty>();
        switch (this.ds.getDatasourceType()) {
            case 1: 
            case 3: {
                pp = new RandomPartitioningProperty(this.domain);
                this.ds.computeLocalStructuralProperties(propsLocal, scanVariables);
                break;
            }
            case 2: {
                pp = DataSourcePartitioningProvider.getFeedPartitioningProperty(this.ds, this.domain, scanVariables);
                break;
            }
            case 0: 
            case 5: {
                ListSet pvars = new ListSet();
                pp = DataSourcePartitioningProvider.getInternalDatasetPartitioningProperty(this.ds, this.domain, scanVariables, (Set<LogicalVariable>)pvars);
                propsLocal.add((ILocalStructuralProperty)new LocalOrderProperty(DataSourcePartitioningProvider.getOrderColumns((Set<LogicalVariable>)pvars)));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        StructuralPropertiesVector propsVector = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
        return propsVector;
    }

    private static List<OrderColumn> getOrderColumns(Set<LogicalVariable> pvars) {
        ArrayList<OrderColumn> orderColumns = new ArrayList<OrderColumn>();
        for (LogicalVariable pkVar : pvars) {
            orderColumns.add(new OrderColumn(pkVar, OrderOperator.IOrder.OrderKind.ASC));
        }
        return orderColumns;
    }

    private static IPartitioningProperty getInternalDatasetPartitioningProperty(DataSource ds, INodeDomain domain, List<LogicalVariable> scanVariables, Set<LogicalVariable> pvars) {
        RandomPartitioningProperty pp;
        if (scanVariables.size() < 2) {
            pp = new RandomPartitioningProperty(domain);
        } else {
            pvars.addAll(ds.getPrimaryKeyVariables(scanVariables));
            pp = new UnorderedPartitionedProperty(pvars, domain);
        }
        return pp;
    }

    public static IPartitioningProperty getFeedPartitioningProperty(DataSource ds, INodeDomain domain, List<LogicalVariable> scanVariables) {
        RandomPartitioningProperty pp;
        if (scanVariables.size() < 2) {
            pp = new RandomPartitioningProperty(domain);
        } else {
            ListSet pvars = new ListSet();
            pvars.addAll(ds.getPrimaryKeyVariables(scanVariables));
            pp = new UnorderedPartitionedProperty((Set)pvars, domain);
        }
        return pp;
    }
}

