/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hyracks.util.ThrowingAction;

public class Span {
    public static final Span INFINITE = new Span(){

        @Override
        public void reset() {
        }

        @Override
        public long getSpanNanos() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getSpan(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean elapsed() {
            return false;
        }

        @Override
        public long elapsed(TimeUnit unit) {
            return -1L;
        }

        @Override
        public void sleep() throws InterruptedException {
            new Semaphore(0).acquire();
        }

        @Override
        public void sleep(long sleep, TimeUnit unit) throws InterruptedException {
            unit.sleep(sleep);
        }

        @Override
        public long remaining(TimeUnit unit) {
            return Long.MAX_VALUE;
        }

        @Override
        public void wait(Object monitor) throws InterruptedException {
            monitor.wait();
        }

        @Override
        public boolean await(CountDownLatch latch) throws InterruptedException {
            latch.await();
            return true;
        }

        @Override
        public String toString() {
            return "<INFINITE>";
        }
    };
    public static final Span ELAPSED = Span.start(0L, TimeUnit.NANOSECONDS);
    private final long spanNanos;
    private volatile long startNanos;

    private Span() {
        this.startNanos = -1L;
        this.spanNanos = -1L;
    }

    private Span(long span, TimeUnit unit) {
        this.spanNanos = unit.toNanos(span);
        this.reset();
    }

    public void reset() {
        this.startNanos = System.nanoTime();
    }

    public long getSpanNanos() {
        return this.spanNanos;
    }

    public long getSpan(TimeUnit unit) {
        return unit.convert(this.spanNanos, TimeUnit.NANOSECONDS);
    }

    public static Span start(long span, TimeUnit unit) {
        return new Span(span, unit);
    }

    public boolean elapsed() {
        return this.elapsed(TimeUnit.NANOSECONDS) > this.spanNanos;
    }

    public long elapsed(TimeUnit unit) {
        return unit.convert(System.nanoTime() - this.startNanos, TimeUnit.NANOSECONDS);
    }

    public void sleep() throws InterruptedException {
        TimeUnit.NANOSECONDS.sleep(this.remaining(TimeUnit.NANOSECONDS));
    }

    public void sleep(long sleep, TimeUnit unit) throws InterruptedException {
        TimeUnit.NANOSECONDS.sleep(Math.min(this.remaining(TimeUnit.NANOSECONDS), unit.toNanos(sleep)));
    }

    public long remaining(TimeUnit unit) {
        return unit.convert(Long.max(this.spanNanos - this.elapsed(TimeUnit.NANOSECONDS), 0L), TimeUnit.NANOSECONDS);
    }

    public void wait(Object monitor) throws InterruptedException {
        TimeUnit.NANOSECONDS.timedWait(monitor, this.remaining(TimeUnit.NANOSECONDS));
    }

    public boolean await(CountDownLatch latch) throws InterruptedException {
        return latch.await(this.remaining(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    public void loopUntilExhausted(ThrowingAction action) throws Exception {
        this.loopUntilExhausted(action, 0L, TimeUnit.NANOSECONDS);
    }

    public void loopUntilExhausted(ThrowingAction action, long delay, TimeUnit delayUnit) throws Exception {
        while (!this.elapsed()) {
            action.run();
            if (this.elapsed(delayUnit) < delay) break;
            this.sleep(delay, delayUnit);
        }
    }

    public String toString() {
        long nanos = this.spanNanos % 1000L;
        long micros = TimeUnit.MICROSECONDS.convert(this.spanNanos, TimeUnit.NANOSECONDS) % 1000L;
        long millis = TimeUnit.MILLISECONDS.convert(this.spanNanos, TimeUnit.NANOSECONDS) % 1000L;
        long seconds = TimeUnit.SECONDS.convert(this.spanNanos, TimeUnit.NANOSECONDS) % 60L;
        long minutes = TimeUnit.MINUTES.convert(this.spanNanos, TimeUnit.NANOSECONDS) % 60L;
        long hours = TimeUnit.HOURS.convert(this.spanNanos, TimeUnit.NANOSECONDS) % 24L;
        long days = TimeUnit.DAYS.convert(this.spanNanos, TimeUnit.NANOSECONDS);
        StringBuilder builder = new StringBuilder();
        if (days > 0L) {
            builder.append(days).append("d");
        }
        if (hours > 0L) {
            builder.append(hours).append("hr");
        }
        if (minutes > 0L) {
            builder.append(minutes).append("m");
        }
        if (seconds > 0L) {
            builder.append(seconds).append("s");
        }
        if (millis > 0L) {
            builder.append(millis).append("ms");
        }
        if (micros > 0L) {
            builder.append(micros).append("us");
        }
        if (nanos > 0L || builder.length() == 0) {
            builder.append(nanos).append("ns");
        }
        return builder.toString();
    }
}

