/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.metadata;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.column.metadata.schema.AbstractSchemaNestedNode;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class PathInfoSerializer {
    private final ArrayBackedValueStorage primaryKeyOutputPathStorage = new ArrayBackedValueStorage();
    private final ArrayBackedValueStorage pathOutputStorage = new ArrayBackedValueStorage();
    private final IntList delimiters = new IntArrayList();
    private int level = 0;

    public void reset() {
        this.primaryKeyOutputPathStorage.reset();
        this.pathOutputStorage.reset();
    }

    public void enter(AbstractSchemaNestedNode nestedNode) {
        if (nestedNode.isCollection()) {
            this.delimiters.add(0, this.level - 1);
        }
        if (nestedNode.isObjectOrCollection()) {
            ++this.level;
        }
    }

    public void exit(AbstractSchemaNestedNode nestedNode) {
        if (nestedNode.isCollection()) {
            this.delimiters.removeInt(0);
        }
        if (nestedNode.isObjectOrCollection()) {
            --this.level;
        }
    }

    public void writePathInfo(ATypeTag typeTag, int columnIndex, boolean primaryKey) throws IOException {
        DataOutput output = primaryKey ? this.primaryKeyOutputPathStorage.getDataOutput() : this.pathOutputStorage.getDataOutput();
        output.write(typeTag.serialize());
        output.writeInt(columnIndex);
        output.writeInt(primaryKey ? 1 : this.level);
        output.writeBoolean(primaryKey);
        boolean collection = !this.delimiters.isEmpty();
        output.writeBoolean(collection);
        if (collection) {
            output.writeInt(this.delimiters.size());
            for (int i = 0; i < this.delimiters.size(); ++i) {
                output.writeInt(this.delimiters.getInt(i));
            }
        }
    }

    public void serialize(DataOutput output, int numberOfColumns) throws IOException {
        output.writeInt(numberOfColumns);
        output.write(this.primaryKeyOutputPathStorage.getByteArray(), 0, this.primaryKeyOutputPathStorage.getLength());
        output.write(this.pathOutputStorage.getByteArray(), 0, this.pathOutputStorage.getLength());
    }
}

