/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.values.writer;

import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.IColumnValuesWriterFactory;
import org.apache.asterix.column.values.writer.BooleanColumnValuesWriter;
import org.apache.asterix.column.values.writer.DoubleColumnValuesWriter;
import org.apache.asterix.column.values.writer.FloatColumnValuesWriter;
import org.apache.asterix.column.values.writer.LongColumnValuesWriter;
import org.apache.asterix.column.values.writer.NullMissingColumnValuesWriter;
import org.apache.asterix.column.values.writer.StringColumnValuesWriter;
import org.apache.asterix.column.values.writer.UUIDColumnValuesWriter;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;

public class ColumnValuesWriterFactory
implements IColumnValuesWriterFactory {
    private final Mutable<IColumnWriteMultiPageOp> multiPageOpRef;

    public ColumnValuesWriterFactory(Mutable<IColumnWriteMultiPageOp> multiPageOpRef) {
        this.multiPageOpRef = multiPageOpRef;
    }

    @Override
    public IColumnValuesWriter createValueWriter(ATypeTag typeTag, int columnIndex, int maxLevel, boolean writeAlways, boolean filtered) {
        switch (typeTag) {
            case MISSING: 
            case NULL: {
                return new NullMissingColumnValuesWriter(columnIndex, maxLevel, writeAlways, filtered);
            }
            case BOOLEAN: {
                return new BooleanColumnValuesWriter(columnIndex, maxLevel, writeAlways, filtered);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return new LongColumnValuesWriter(this.multiPageOpRef, columnIndex, maxLevel, writeAlways, filtered, typeTag);
            }
            case FLOAT: {
                return new FloatColumnValuesWriter(this.multiPageOpRef, columnIndex, maxLevel, writeAlways, filtered);
            }
            case DOUBLE: {
                return new DoubleColumnValuesWriter(this.multiPageOpRef, columnIndex, maxLevel, writeAlways, filtered);
            }
            case STRING: {
                return new StringColumnValuesWriter(this.multiPageOpRef, columnIndex, maxLevel, writeAlways, filtered);
            }
            case UUID: {
                return new UUIDColumnValuesWriter(this.multiPageOpRef, columnIndex, maxLevel, writeAlways, filtered);
            }
        }
        throw new UnsupportedOperationException(typeTag + " is not supported");
    }
}

