/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import org.apache.asterix.app.function.TPCDSDataGeneratorFunction;
import org.apache.asterix.app.function.TPCDSSingleTableDataGeneratorRewriter;
import org.apache.asterix.common.cluster.IClusterStateManager;
import org.apache.asterix.metadata.api.IDatasourceFunction;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;

public class TPCDSSingleTableDataGeneratorDatasource
extends FunctionDataSource {
    private final String tableName;
    private final double scalingFactor;

    TPCDSSingleTableDataGeneratorDatasource(INodeDomain domain, String tableName, double scalingFactor, FunctionIdentifier functionIdentifier) throws AlgebricksException {
        super(TPCDSSingleTableDataGeneratorDatasource.createDataSourceId(tableName, scalingFactor), functionIdentifier, domain);
        this.tableName = tableName;
        this.scalingFactor = scalingFactor;
    }

    private static DataSourceId createDataSourceId(String tableName, double scalingFactor) {
        return TPCDSSingleTableDataGeneratorDatasource.createDataSourceId((FunctionIdentifier)TPCDSSingleTableDataGeneratorRewriter.TPCDS_SINGLE_TABLE_DATA_GENERATOR, (String[])new String[]{tableName, Double.toString(scalingFactor)});
    }

    protected IDatasourceFunction createFunction(MetadataProvider metadataProvider, AlgebricksAbsolutePartitionConstraint locations) {
        return new TPCDSDataGeneratorFunction(locations, this.tableName, this.scalingFactor, this.functionId);
    }

    protected AlgebricksAbsolutePartitionConstraint getLocations(IClusterStateManager csm, MetadataProvider md) {
        return md.getDataPartitioningProvider().getClusterLocations();
    }
}

