/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.List;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.PrivilegedSQLObject;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.execute.GenericPrivilegeInfo;
import org.apache.derby.impl.sql.execute.PrivilegeInfo;
import org.apache.derby.shared.common.sanity.SanityManager;

class PrivilegeNode
extends QueryTreeNode {
    public static final int TABLE_PRIVILEGES = 0;
    public static final int ROUTINE_PRIVILEGES = 1;
    public static final int SEQUENCE_PRIVILEGES = 2;
    public static final int UDT_PRIVILEGES = 3;
    public static final int AGGREGATE_PRIVILEGES = 4;
    private int objectType;
    private TableName objectName;
    private TablePrivilegesNode specificPrivileges;
    private RoutineDesignator routineDesignator;
    private String privilege;
    private boolean restrict;
    private Provider dependencyProvider;

    PrivilegeNode(int objectType, Object objectOfPrivilege, TablePrivilegesNode specificPrivileges, ContextManager cm) throws StandardException {
        super(cm);
        this.objectType = objectType;
        SanityManager.ASSERT(objectOfPrivilege != null, "null privilge object");
        switch (this.objectType) {
            case 0: {
                SanityManager.ASSERT(specificPrivileges != null, "null specific privileges used with table privilege");
                this.objectName = (TableName)objectOfPrivilege;
                this.specificPrivileges = specificPrivileges;
                break;
            }
            case 1: {
                SanityManager.ASSERT(specificPrivileges == null, "non-null specific privileges used with execute privilege");
                this.routineDesignator = (RoutineDesignator)objectOfPrivilege;
                this.objectName = this.routineDesignator.name;
                break;
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
    }

    PrivilegeNode(int objectType, TableName objectName, String privilege, boolean restrict, ContextManager cm) {
        super(cm);
        this.objectType = objectType;
        this.objectName = objectName;
        this.privilege = privilege;
        this.restrict = restrict;
    }

    public QueryTreeNode bind(HashMap<Provider, Provider> dependencies, List<String> grantees, boolean isGrant) throws StandardException {
        SchemaDescriptor sd = this.getSchemaDescriptor(this.objectName.getSchemaName(), true);
        this.objectName.setSchemaName(sd.getSchemaName());
        if (grantees.contains(sd.getAuthorizationId())) {
            throw StandardException.newException("42509", this.objectName.getFullTableName());
        }
        switch (this.objectType) {
            case 0: {
                if (sd.isSystemSchema()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                TableDescriptor td = this.getTableDescriptor(this.objectName.getTableName(), sd);
                if (td == null) {
                    throw StandardException.newException("42X05", this.objectName);
                }
                if (PrivilegeNode.isSessionSchema(sd.getSchemaName())) {
                    throw StandardException.newException("XCL51.S", new Object[0]);
                }
                if (td.getTableType() != 0 && td.getTableType() != 2) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                this.specificPrivileges.bind(td, isGrant);
                this.dependencyProvider = td;
                break;
            }
            case 1: {
                if (!sd.isSchemaWithGrantableRoutines()) {
                    throw StandardException.newException("42509", this.objectName.getFullTableName());
                }
                AliasDescriptor proc = null;
                List<AliasDescriptor> list = this.getDataDictionary().getRoutineList(sd.getUUID().toString(), this.objectName.getTableName(), this.routineDesignator.isFunction ? (char)'F' : 'P');
                if (this.routineDesignator.paramTypeList == null) {
                    if (list.size() > 1) {
                        throw StandardException.newException(this.routineDesignator.isFunction ? "42X46" : "42X47", this.objectName.getFullTableName());
                    }
                    if (list.size() != 1) {
                        if (this.routineDesignator.isFunction) {
                            throw StandardException.newException("42Y03.S.2", this.objectName.getFullTableName());
                        }
                        throw StandardException.newException("42Y03.S.1", this.objectName.getFullTableName());
                    }
                    proc = list.get(0);
                } else {
                    boolean found = false;
                    block7: for (int i = list.size() - 1; !found && i >= 0; --i) {
                        proc = list.get(i);
                        RoutineAliasInfo routineInfo = (RoutineAliasInfo)proc.getAliasInfo();
                        int parameterCount = routineInfo.getParameterCount();
                        if (parameterCount != this.routineDesignator.paramTypeList.size()) continue;
                        TypeDescriptor[] parameterTypes = routineInfo.getParameterTypes();
                        found = true;
                        for (int parmIdx = 0; parmIdx < parameterCount; ++parmIdx) {
                            if (parameterTypes[parmIdx].equals(this.routineDesignator.paramTypeList.get(parmIdx))) continue;
                            found = false;
                            continue block7;
                        }
                    }
                    if (!found) {
                        StringBuilder sb = new StringBuilder(this.objectName.getFullTableName());
                        sb.append("(");
                        for (int i = 0; i < this.routineDesignator.paramTypeList.size(); ++i) {
                            if (i > 0) {
                                sb.append(",");
                            }
                            sb.append(this.routineDesignator.paramTypeList.get(i).toString());
                        }
                        throw StandardException.newException("42Y03.S.0", sb.toString());
                    }
                }
                this.routineDesignator.setAliasDescriptor(proc);
                this.dependencyProvider = proc;
                break;
            }
            case 4: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(sd.getUUID().toString(), this.objectName.getTableName(), 'G');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "DERBY AGGREGATE", this.objectName.getFullTableName());
            }
            case 2: {
                this.dependencyProvider = this.getDataDictionary().getSequenceDescriptor(sd, this.objectName.getTableName());
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "SEQUENCE", this.objectName.getFullTableName());
            }
            case 3: {
                this.dependencyProvider = this.getDataDictionary().getAliasDescriptor(sd.getUUID().toString(), this.objectName.getTableName(), 'A');
                if (this.dependencyProvider != null) break;
                throw StandardException.newException("42X94", "TYPE", this.objectName.getFullTableName());
            }
            default: {
                throw this.unimplementedFeature();
            }
        }
        if (this.dependencyProvider != null && dependencies.get(this.dependencyProvider) == null) {
            this.getCompilerContext().createDependency(this.dependencyProvider);
            dependencies.put(this.dependencyProvider, this.dependencyProvider);
        }
        return this;
    }

    PrivilegeInfo makePrivilegeInfo() throws StandardException {
        switch (this.objectType) {
            case 0: {
                return this.specificPrivileges.makePrivilegeInfo();
            }
            case 1: {
                return this.routineDesignator.makePrivilegeInfo();
            }
            case 2: 
            case 3: 
            case 4: {
                return new GenericPrivilegeInfo((PrivilegedSQLObject)this.dependencyProvider, this.privilege, this.restrict);
            }
        }
        throw this.unimplementedFeature();
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.objectName != null) {
            this.objectName = (TableName)this.objectName.accept(v);
        }
    }
}

