/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.operators.deduplicate.MiniBatchDeduplicateFunctionBase;
import org.apache.flink.util.Collector;

public class ProcTimeMiniBatchDeduplicateKeepFirstRowFunction
extends MiniBatchDeduplicateFunctionBase<Boolean, RowData, RowData, RowData, RowData> {
    private static final long serialVersionUID = -7994602893547654994L;
    private final TypeSerializer<RowData> serializer;

    public ProcTimeMiniBatchDeduplicateKeepFirstRowFunction(TypeSerializer<RowData> serializer, long stateRetentionTime) {
        super(Types.BOOLEAN, stateRetentionTime);
        this.serializer = serializer;
    }

    @Override
    public RowData addInput(@Nullable RowData value, RowData input) {
        if (value == null) {
            return this.serializer.copy(input);
        }
        return value;
    }

    @Override
    public void finishBundle(Map<RowData, RowData> buffer, Collector<RowData> out) throws Exception {
        for (Map.Entry<RowData, RowData> entry : buffer.entrySet()) {
            RowData currentKey = entry.getKey();
            RowData currentRow = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            DeduplicateFunctionHelper.processFirstRowOnProcTime(currentRow, this.state, out);
        }
    }
}

