/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.geode.annotations.Immutable;

@Immutable
public class AlertLevel
implements Serializable {
    private static final long serialVersionUID = -4752438966587392126L;
    @Immutable
    public static final AlertLevel WARNING = new AlertLevel(900, "WARNING", 0);
    @Immutable
    public static final AlertLevel ERROR = new AlertLevel(950, "ERROR", 1);
    @Immutable
    public static final AlertLevel SEVERE = new AlertLevel(1000, "SEVERE", 2);
    @Immutable
    public static final AlertLevel OFF = new AlertLevel(Integer.MAX_VALUE, "OFF", 3);
    private final transient int severity;
    private final transient String name;
    public final int ordinal;
    @Immutable
    private static final AlertLevel[] VALUES = new AlertLevel[]{WARNING, ERROR, SEVERE, OFF};

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    private AlertLevel(int severity, String name, int ordinal) {
        this.severity = severity;
        this.name = name;
        this.ordinal = ordinal;
    }

    public static AlertLevel fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    public static AlertLevel forSeverity(int severity) {
        switch (severity) {
            case 900: {
                return WARNING;
            }
            case 950: {
                return ERROR;
            }
            case 1000: {
                return SEVERE;
            }
            case 0x7FFFFFFF: {
                return OFF;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown alert severity: %s", severity));
    }

    public static AlertLevel forName(String name) {
        for (int i = 0; i < VALUES.length; ++i) {
            AlertLevel level = VALUES[i];
            if (!level.getName().equalsIgnoreCase(name)) continue;
            return level;
        }
        throw new IllegalArgumentException(String.format("There is no alert level %s", name));
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getName() {
        return this.name;
    }

    public static AlertLevel[] values() {
        return VALUES;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof AlertLevel)) {
            return false;
        }
        AlertLevel that = (AlertLevel)other;
        if (this.severity != that.severity) {
            return false;
        }
        return this.name == null || this.name.equals(that.name);
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.severity;
        result = 37 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

