/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.persistence;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.geode.internal.cache.persistence.OplogType;

public class DiskStoreFilter
implements FilenameFilter {
    private final String filterCondn;
    private final boolean includeKRF;

    public DiskStoreFilter(OplogType type, boolean includeKRF, String name) {
        this.includeKRF = includeKRF;
        this.filterCondn = new StringBuffer(type.getPrefix()).append(name).toString();
    }

    private boolean selected(String fileName) {
        if (this.includeKRF) {
            return fileName.endsWith(".crf") || fileName.endsWith(".krf") || fileName.endsWith(".drf");
        }
        return fileName.endsWith(".crf") || fileName.endsWith(".drf");
    }

    @Override
    public boolean accept(File f, String fileName) {
        if (this.selected(fileName)) {
            int positionOfLastDot = fileName.lastIndexOf(95);
            String filePathWithoutNumberAndExtension = fileName.substring(0, positionOfLastDot);
            boolean result = this.filterCondn.equals(filePathWithoutNumberAndExtension);
            return result;
        }
        return false;
    }
}

