/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories.strategy;

import java.io.IOException;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.utils.CommonUtils;

public class MinFolderOccupiedSpaceFirstStrategy
extends DirectoryStrategy {
    @Override
    public int nextFolderIndex() throws DiskSpaceInsufficientException {
        return this.getMinOccupiedSpaceFolder();
    }

    private int getMinOccupiedSpaceFolder() throws DiskSpaceInsufficientException {
        int minIndex = -1;
        long minSpace = Long.MAX_VALUE;
        for (int i = 0; i < this.folders.size(); ++i) {
            String folder = (String)this.folders.get(i);
            if (!CommonUtils.hasSpace(folder)) continue;
            long space = 0L;
            try {
                space = CommonUtils.getOccupiedSpace(folder);
            }
            catch (IOException e) {
                logger.error("Cannot calculate occupied space for path {}.", (Object)folder, (Object)e);
            }
            if (space >= minSpace) continue;
            minSpace = space;
            minIndex = i;
        }
        if (minIndex == -1) {
            throw new DiskSpaceInsufficientException(this.folders);
        }
        return minIndex;
    }
}

