/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils.nodetool.function;

import io.airlift.airline.Command;
import java.util.Map;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.utils.nodetool.ClusterMonitorMBean;
import org.apache.iotdb.cluster.utils.nodetool.Printer;
import org.apache.iotdb.cluster.utils.nodetool.function.NodeToolCmd;

@Command(name="status", description="Print status of all nodes")
public class Status
extends NodeToolCmd {
    public static final int LIVE = 0;
    public static final int OFFLINE = 1;
    public static final int JOINING = 2;
    public static final int LEAVING = 3;

    @Override
    public void execute(ClusterMonitorMBean proxy) {
        Map<Node, Integer> statusMap = proxy.getAllNodeStatus();
        if (statusMap == null) {
            Printer.msgPrintln("The cluster is being created.");
            return;
        }
        Printer.msgPrintln(String.format("%-30s  %10s", "Node", "Status"));
        for (Map.Entry<Node, Integer> entry : statusMap.entrySet()) {
            Node node = entry.getKey();
            Integer statusNum = entry.getValue();
            String status = statusNum.equals(0) ? "on" : (statusNum.equals(1) ? "off" : (statusNum.equals(2) ? "joining" : "leaving"));
            Printer.msgPrintln(String.format("%-30s->%10s", Status.nodeToString(node), status));
        }
    }
}

