/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.cache.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.view.InsertNonWritableViewException;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.SchemaCacheEntry;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCache;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.IDualKeyCacheUpdating;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCacheBuilder;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.dualkeycache.impl.DualKeyCachePolicy;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.lastcache.DataNodeLastCacheManager;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.tsfile.read.TimeValuePair;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesSchemaCache {
    private static final Logger logger = LoggerFactory.getLogger(DataNodeSchemaCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final IDualKeyCache<PartialPath, String, SchemaCacheEntry> dualKeyCache;

    TimeSeriesSchemaCache() {
        DualKeyCacheBuilder dualKeyCacheBuilder = new DualKeyCacheBuilder();
        this.dualKeyCache = dualKeyCacheBuilder.cacheEvictionPolicy(DualKeyCachePolicy.valueOf(config.getDataNodeSchemaCacheEvictionPolicy())).memoryCapacity(config.getAllocateMemoryForSchemaCache()).firstKeySizeComputer(PartialPath::estimateSize).secondKeySizeComputer(s -> 32 + 2 * s.length()).valueSizeComputer(SchemaCacheEntry::estimateSize).build();
    }

    public long getHitCount() {
        return this.dualKeyCache.stats().hitCount();
    }

    public long getRequestCount() {
        return this.dualKeyCache.stats().requestCount();
    }

    public ClusterSchemaTree get(final PartialPath devicePath, final String[] measurements) {
        final ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        final HashSet<String> storageGroupSet = new HashSet<String>();
        this.dualKeyCache.compute(new IDualKeyCacheComputation<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return devicePath;
            }

            public String[] getSecondKeyList() {
                return measurements;
            }

            @Override
            public void computeValue(int index, SchemaCacheEntry value) {
                if (value != null) {
                    schemaTree.appendSingleMeasurement(devicePath.concatNode(value.getSchemaEntryId()), value.getIMeasurementSchema(), value.getTagMap(), null, null, value.isAligned());
                    storageGroupSet.add(value.getStorageGroup());
                }
            }
        });
        schemaTree.setDatabases(storageGroupSet);
        return schemaTree;
    }

    public ClusterSchemaTree get(PartialPath fullPath) {
        SchemaCacheEntry schemaCacheEntry = this.dualKeyCache.get(fullPath.getDevicePath(), fullPath.getMeasurement());
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        if (schemaCacheEntry != null) {
            schemaTree.appendSingleMeasurement(fullPath, schemaCacheEntry.getIMeasurementSchema(), schemaCacheEntry.getTagMap(), null, null, schemaCacheEntry.isAligned());
            schemaTree.setDatabases(Collections.singleton(schemaCacheEntry.getStorageGroup()));
        }
        return schemaTree;
    }

    public List<Integer> computeAndRecordLogicalView(final ISchemaComputation schemaComputation) {
        final ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        final AtomicBoolean isFirstNonViewMeasurement = new AtomicBoolean(true);
        this.dualKeyCache.compute(new IDualKeyCacheComputation<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return schemaComputation.getDevicePath();
            }

            public String[] getSecondKeyList() {
                return schemaComputation.getMeasurements();
            }

            @Override
            public void computeValue(int index, SchemaCacheEntry value) {
                if (value == null) {
                    indexOfMissingMeasurements.add(index);
                } else {
                    if (isFirstNonViewMeasurement.get() && !value.isLogicalView()) {
                        schemaComputation.computeDevice(value.isAligned());
                        isFirstNonViewMeasurement.getAndSet(false);
                    }
                    schemaComputation.computeMeasurement(index, value);
                }
            }
        });
        return indexOfMissingMeasurements;
    }

    public Pair<List<Integer>, List<String>> computeSourceOfLogicalView(final ISchemaComputation schemaComputation) {
        final ArrayList indexOfMissingMeasurements = new ArrayList();
        ArrayList<String> missedPathStringList = new ArrayList<String>();
        Pair<Integer, Integer> beginToEnd = schemaComputation.getRangeOfLogicalViewSchemaListRecorded();
        List<LogicalViewSchema> logicalViewSchemaList = schemaComputation.getLogicalViewSchemaList();
        List<Integer> indexListOfLogicalViewPaths = schemaComputation.getIndexListOfLogicalViewPaths();
        int i = (Integer)beginToEnd.left;
        while (i < (Integer)beginToEnd.right) {
            LogicalViewSchema logicalViewSchema = logicalViewSchemaList.get(i);
            final int realIndex = indexListOfLogicalViewPaths.get(i);
            final int recordMissingIndex = i++;
            if (!logicalViewSchema.isWritable()) {
                PartialPath path = schemaComputation.getDevicePath();
                path = path.concatNode(schemaComputation.getMeasurements()[realIndex]);
                throw new RuntimeException((Throwable)((Object)new InsertNonWritableViewException(path.getFullPath())));
            }
            final PartialPath fullPath = logicalViewSchema.getSourcePathIfWritable();
            this.dualKeyCache.compute(new IDualKeyCacheComputation<PartialPath, String, SchemaCacheEntry>(){

                @Override
                public PartialPath getFirstKey() {
                    return fullPath.getDevicePath();
                }

                public String[] getSecondKeyList() {
                    return new String[]{fullPath.getMeasurement()};
                }

                @Override
                public void computeValue(int index, SchemaCacheEntry value) {
                    if (value == null) {
                        indexOfMissingMeasurements.add(recordMissingIndex);
                    } else {
                        if (value.isLogicalView()) {
                            throw new RuntimeException(new UnsupportedOperationException(String.format("The source of view [%s] is also a view! Nested view is unsupported! Please check it.", fullPath)));
                        }
                        schemaComputation.computeMeasurementOfView(realIndex, value, value.isAligned());
                    }
                }
            });
        }
        Iterator iterator = indexOfMissingMeasurements.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            missedPathStringList.add(logicalViewSchemaList.get(index).getSourcePathStringIfWritable());
        }
        return new Pair(indexOfMissingMeasurements, missedPathStringList);
    }

    public void putSingleMeasurementPath(String storageGroup, MeasurementPath measurementPath) {
        SchemaCacheEntry schemaCacheEntry = new SchemaCacheEntry(storageGroup, measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), measurementPath.isUnderAlignedEntity());
        this.dualKeyCache.put(measurementPath.getDevicePath(), measurementPath.getMeasurement(), schemaCacheEntry);
    }

    public TimeValuePair getLastCache(PartialPath seriesPath) {
        SchemaCacheEntry entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
        if (null == entry) {
            return null;
        }
        return DataNodeLastCacheManager.getLastCache(entry);
    }

    public void updateLastCache(PartialPath devicePath, String measurement, TimeValuePair timeValuePair, boolean highPriorityUpdate, Long latestFlushedTime) {
        SchemaCacheEntry entry = this.dualKeyCache.get(devicePath, measurement);
        if (null == entry) {
            return;
        }
        DataNodeLastCacheManager.updateLastCache(entry, timeValuePair, highPriorityUpdate, latestFlushedTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(String database, final PartialPath devicePath, final String[] measurements, MeasurementSchema[] measurementSchemas, boolean isAligned, final IntFunction<TimeValuePair> timeValuePairProvider, final IntPredicate shouldUpdateProvider, final boolean highPriorityUpdate, final Long latestFlushedTime) {
        final ArrayList missingMeasurements = new ArrayList();
        this.dualKeyCache.update(new IDualKeyCacheUpdating<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return devicePath;
            }

            public String[] getSecondKeyList() {
                return measurements;
            }

            @Override
            public int updateValue(int index, SchemaCacheEntry value) {
                if (!shouldUpdateProvider.test(index)) {
                    return 0;
                }
                if (value == null) {
                    missingMeasurements.add(index);
                    return 0;
                }
                return DataNodeLastCacheManager.updateLastCache(value, (TimeValuePair)timeValuePairProvider.apply(index), highPriorityUpdate, latestFlushedTime);
            }
        });
        Iterator iterator = missingMeasurements.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            SchemaCacheEntry entry = this.dualKeyCache.get(devicePath, measurements[index]);
            if (entry != null) continue;
            IDualKeyCache<PartialPath, String, SchemaCacheEntry> iDualKeyCache = this.dualKeyCache;
            synchronized (iDualKeyCache) {
                entry = this.dualKeyCache.get(devicePath, measurements[index]);
                if (null == entry && measurementSchemas != null) {
                    entry = new SchemaCacheEntry(database, (IMeasurementSchema)measurementSchemas[index], null, isAligned);
                    this.dualKeyCache.put(devicePath, measurements[index], entry);
                }
            }
        }
        this.dualKeyCache.update(new IDualKeyCacheUpdating<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return devicePath;
            }

            public String[] getSecondKeyList() {
                return (String[])missingMeasurements.stream().map(i -> measurements[i]).toArray(String[]::new);
            }

            @Override
            public int updateValue(int index, SchemaCacheEntry value) {
                return DataNodeLastCacheManager.updateLastCache(value, (TimeValuePair)timeValuePairProvider.apply((Integer)missingMeasurements.get(index)), highPriorityUpdate, latestFlushedTime);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastCache(String storageGroup, final MeasurementPath measurementPath, final TimeValuePair timeValuePair, final boolean highPriorityUpdate, final Long latestFlushedTime) {
        PartialPath seriesPath = measurementPath.transformToPartialPath();
        SchemaCacheEntry entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
        if (null == entry) {
            IDualKeyCache<PartialPath, String, SchemaCacheEntry> iDualKeyCache = this.dualKeyCache;
            synchronized (iDualKeyCache) {
                entry = this.dualKeyCache.get(seriesPath.getDevicePath(), seriesPath.getMeasurement());
                if (null == entry) {
                    entry = new SchemaCacheEntry(storageGroup, measurementPath.getMeasurementSchema(), measurementPath.getTagMap(), measurementPath.isUnderAlignedEntity());
                    this.dualKeyCache.put(seriesPath.getDevicePath(), seriesPath.getMeasurement(), entry);
                }
            }
        }
        this.dualKeyCache.update(new IDualKeyCacheUpdating<PartialPath, String, SchemaCacheEntry>(){

            @Override
            public PartialPath getFirstKey() {
                return measurementPath.getDevicePath();
            }

            public String[] getSecondKeyList() {
                return new String[]{measurementPath.getMeasurement()};
            }

            @Override
            public int updateValue(int index, SchemaCacheEntry value) {
                return DataNodeLastCacheManager.updateLastCache(value, timeValuePair, highPriorityUpdate, latestFlushedTime);
            }
        });
    }

    public void invalidateAll() {
        this.dualKeyCache.invalidateAll();
    }

    public void invalidate(String database) {
        this.dualKeyCache.invalidate(database);
    }

    public void invalidateLastCache(final PartialPath path) {
        if (!path.hasWildcard()) {
            SchemaCacheEntry entry = this.dualKeyCache.get(path.getDevicePath(), path.getMeasurement());
            if (null == entry) {
                return;
            }
            this.dualKeyCache.update(new IDualKeyCacheUpdating<PartialPath, String, SchemaCacheEntry>(){

                @Override
                public PartialPath getFirstKey() {
                    return path.getDevicePath();
                }

                public String[] getSecondKeyList() {
                    return new String[]{path.getMeasurement()};
                }

                @Override
                public int updateValue(int index, SchemaCacheEntry value) {
                    return -DataNodeLastCacheManager.invalidateLastCache(value);
                }
            });
        } else {
            this.dualKeyCache.invalidateLastCache(path);
        }
    }

    public void invalidateDataRegionLastCache(String database) {
        this.dualKeyCache.invalidateDataRegionLastCache(database);
    }

    public void invalidate(List<PartialPath> partialPathList) {
        this.dualKeyCache.invalidate(partialPathList);
    }

    public void cleanUp() {
        this.dualKeyCache.cleanUp();
    }
}

