/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.LongUnaryOperator;
import org.apache.iotdb.db.pipe.resource.PipeDataNodeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeMemoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeMemoryBlock
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeMemoryBlock.class);
    private final PipeMemoryManager pipeMemoryManager = PipeDataNodeResourceManager.memory();
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicLong memoryUsageInBytes = new AtomicLong(0L);
    private final AtomicReference<LongUnaryOperator> shrinkMethod = new AtomicReference();
    private final AtomicReference<BiConsumer<Long, Long>> shrinkCallback = new AtomicReference();
    private final AtomicReference<LongUnaryOperator> expandMethod = new AtomicReference();
    private final AtomicReference<BiConsumer<Long, Long>> expandCallback = new AtomicReference();
    private volatile boolean isReleased = false;

    public PipeMemoryBlock(long memoryUsageInBytes) {
        this.memoryUsageInBytes.set(memoryUsageInBytes);
    }

    public long getMemoryUsageInBytes() {
        return this.memoryUsageInBytes.get();
    }

    public void setMemoryUsageInBytes(long memoryUsageInBytes) {
        this.memoryUsageInBytes.set(memoryUsageInBytes);
    }

    public PipeMemoryBlock setShrinkMethod(LongUnaryOperator shrinkMethod) {
        this.shrinkMethod.set(shrinkMethod);
        return this;
    }

    public PipeMemoryBlock setShrinkCallback(BiConsumer<Long, Long> shrinkCallback) {
        this.shrinkCallback.set(shrinkCallback);
        return this;
    }

    public PipeMemoryBlock setExpandMethod(LongUnaryOperator extendMethod) {
        this.expandMethod.set(extendMethod);
        return this;
    }

    public PipeMemoryBlock setExpandCallback(BiConsumer<Long, Long> expandCallback) {
        this.expandCallback.set(expandCallback);
        return this;
    }

    boolean shrink() {
        if (this.lock.tryLock()) {
            try {
                boolean bl = this.doShrink();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private boolean doShrink() {
        long newMemorySizeInBytes;
        if (this.shrinkMethod.get() == null) {
            return false;
        }
        long oldMemorySizeInBytes = this.memoryUsageInBytes.get();
        long memoryInBytesCanBeReleased = oldMemorySizeInBytes - (newMemorySizeInBytes = this.shrinkMethod.get().applyAsLong(this.memoryUsageInBytes.get()));
        if (memoryInBytesCanBeReleased <= 0L || !this.pipeMemoryManager.release(this, memoryInBytesCanBeReleased)) {
            return false;
        }
        if (this.shrinkCallback.get() != null) {
            try {
                this.shrinkCallback.get().accept(oldMemorySizeInBytes, newMemorySizeInBytes);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to execute the shrink callback.", (Throwable)e);
            }
        }
        return true;
    }

    boolean expand() {
        if (this.lock.tryLock()) {
            try {
                boolean bl = this.doExpand();
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return false;
    }

    private boolean doExpand() {
        if (this.expandMethod.get() == null) {
            return false;
        }
        long oldMemorySizeInBytes = this.memoryUsageInBytes.get();
        long newMemorySizeInBytes = this.expandMethod.get().applyAsLong(this.memoryUsageInBytes.get());
        long memoryInBytesNeededToBeAllocated = newMemorySizeInBytes - oldMemorySizeInBytes;
        if (memoryInBytesNeededToBeAllocated <= 0L || !this.pipeMemoryManager.tryAllocate(this, memoryInBytesNeededToBeAllocated)) {
            return false;
        }
        if (this.expandCallback.get() != null) {
            try {
                this.expandCallback.get().accept(oldMemorySizeInBytes, newMemorySizeInBytes);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to execute the expand callback.", (Throwable)e);
            }
        }
        return true;
    }

    boolean isReleased() {
        return this.isReleased;
    }

    void markAsReleased() {
        this.isReleased = true;
    }

    public String toString() {
        return "PipeMemoryBlock{memoryUsageInBytes=" + this.memoryUsageInBytes.get() + ", isReleased=" + this.isReleased + '}';
    }

    @Override
    public void close() {
        boolean isInterrupted = false;
        while (true) {
            try {
                while (!this.lock.tryLock(50L, TimeUnit.MICROSECONDS)) {
                }
                try {
                    this.pipeMemoryManager.release(this);
                    if (isInterrupted) {
                        LOGGER.warn("{} is released after thread interruption.", (Object)this);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                isInterrupted = true;
                LOGGER.warn("Interrupted while waiting for the lock.", (Throwable)e);
                continue;
            }
            break;
        }
        if (isInterrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

