/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tsfile.encoding.encoder.Encoder;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitmapEncoder
extends Encoder {
    private static final Logger logger = LoggerFactory.getLogger(BitmapEncoder.class);
    private List<Integer> values = new ArrayList<Integer>();

    public BitmapEncoder() {
        super(TSEncoding.BITMAP);
        logger.debug("tsfile-encoding BitmapEncoder: init bitmap encoder");
    }

    @Override
    public void encode(int value, ByteArrayOutputStream out) {
        this.values.add(value);
    }

    @Override
    public void flush(ByteArrayOutputStream out) throws IOException {
        ByteArrayOutputStream byteCache = new ByteArrayOutputStream();
        HashSet<Integer> valueType = new HashSet<Integer>(this.values);
        int byteNum = (this.values.size() + 7) / 8;
        if (byteNum == 0) {
            this.reset();
            return;
        }
        int len = this.values.size();
        Iterator iterator = valueType.iterator();
        while (iterator.hasNext()) {
            int value = (Integer)iterator.next();
            byte[] buffer = new byte[byteNum];
            for (int i = 0; i < len; ++i) {
                if (this.values.get(i) != value) continue;
                int index = i / 8;
                int offset = 7 - i % 8;
                int n = index;
                buffer[n] = (byte)(buffer[n] | 1 << offset);
            }
            ReadWriteForEncodingUtils.writeUnsignedVarInt(value, byteCache);
            byteCache.write(buffer);
        }
        ReadWriteForEncodingUtils.writeUnsignedVarInt(byteCache.size(), out);
        ReadWriteForEncodingUtils.writeUnsignedVarInt(len, out);
        out.write(byteCache.toByteArray());
        this.reset();
    }

    private void reset() {
        this.values.clear();
    }

    @Override
    public int getOneItemMaxSize() {
        return 1;
    }

    @Override
    public long getMaxByteSize() {
        return 8L + (long)(((this.values.size() + 7) / 8 + 4) * this.values.size());
    }
}

