/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.InstanceNode;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceNode;

public class MethodNode
extends InstanceNode
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=276");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=278");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=277");
    private final Boolean executable;
    private final Boolean userExecutable;

    public MethodNode(NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, ReferenceNode[] references, Boolean executable, Boolean userExecutable) {
        super(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references);
        this.executable = executable;
        this.userExecutable = userExecutable;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public Boolean getExecutable() {
        return this.executable;
    }

    public Boolean getUserExecutable() {
        return this.userExecutable;
    }

    protected MethodNode(MethodNodeBuilder<?, ?> b) {
        super((InstanceNode.InstanceNodeBuilder<?, ?>)b);
        this.executable = ((MethodNodeBuilder)b).executable;
        this.userExecutable = ((MethodNodeBuilder)b).userExecutable;
    }

    public static MethodNodeBuilder<?, ?> builder() {
        return new MethodNodeBuilderImpl();
    }

    @Override
    public MethodNodeBuilder<?, ?> toBuilder() {
        return new MethodNodeBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodNode)) {
            return false;
        }
        MethodNode other = (MethodNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$executable = this.getExecutable();
        Boolean other$executable = other.getExecutable();
        if (this$executable == null ? other$executable != null : !((Object)this$executable).equals(other$executable)) {
            return false;
        }
        Boolean this$userExecutable = this.getUserExecutable();
        Boolean other$userExecutable = other.getUserExecutable();
        return !(this$userExecutable == null ? other$userExecutable != null : !((Object)this$userExecutable).equals(other$userExecutable));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MethodNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $executable = this.getExecutable();
        result = result * 59 + ($executable == null ? 43 : ((Object)$executable).hashCode());
        Boolean $userExecutable = this.getUserExecutable();
        result = result * 59 + ($userExecutable == null ? 43 : ((Object)$userExecutable).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MethodNode(executable=" + this.getExecutable() + ", userExecutable=" + this.getUserExecutable() + ")";
    }

    private static final class MethodNodeBuilderImpl
    extends MethodNodeBuilder<MethodNode, MethodNodeBuilderImpl> {
        private MethodNodeBuilderImpl() {
        }

        @Override
        protected MethodNodeBuilderImpl self() {
            return this;
        }

        @Override
        public MethodNode build() {
            return new MethodNode(this);
        }
    }

    public static abstract class MethodNodeBuilder<C extends MethodNode, B extends MethodNodeBuilder<C, B>>
    extends InstanceNode.InstanceNodeBuilder<C, B> {
        private Boolean executable;
        private Boolean userExecutable;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MethodNodeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(MethodNode instance, MethodNodeBuilder<?, ?> b) {
            b.executable(instance.executable);
            b.userExecutable(instance.userExecutable);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B executable(Boolean executable) {
            this.executable = executable;
            return (B)this.self();
        }

        public B userExecutable(Boolean userExecutable) {
            this.userExecutable = userExecutable;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "MethodNode.MethodNodeBuilder(super=" + super.toString() + ", executable=" + this.executable + ", userExecutable=" + this.userExecutable + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<MethodNode> {
        @Override
        public Class<MethodNode> getType() {
            return MethodNode.class;
        }

        @Override
        public MethodNode decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            NodeClass nodeClass = decoder.readEnum("NodeClass", NodeClass.class);
            QualifiedName browseName = decoder.readQualifiedName("BrowseName");
            LocalizedText displayName = decoder.readLocalizedText("DisplayName");
            LocalizedText description = decoder.readLocalizedText("Description");
            UInteger writeMask = decoder.readUInt32("WriteMask");
            UInteger userWriteMask = decoder.readUInt32("UserWriteMask");
            ReferenceNode[] references = (ReferenceNode[])decoder.readStructArray("References", ReferenceNode.TYPE_ID);
            Boolean executable = decoder.readBoolean("Executable");
            Boolean userExecutable = decoder.readBoolean("UserExecutable");
            return new MethodNode(nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, references, executable, userExecutable);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, MethodNode value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeEnum("NodeClass", value.getNodeClass());
            encoder.writeQualifiedName("BrowseName", value.getBrowseName());
            encoder.writeLocalizedText("DisplayName", value.getDisplayName());
            encoder.writeLocalizedText("Description", value.getDescription());
            encoder.writeUInt32("WriteMask", value.getWriteMask());
            encoder.writeUInt32("UserWriteMask", value.getUserWriteMask());
            encoder.writeStructArray("References", (Object[])value.getReferences(), ReferenceNode.TYPE_ID);
            encoder.writeBoolean("Executable", value.getExecutable());
            encoder.writeBoolean("UserExecutable", value.getUserExecutable());
        }
    }
}

