/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.javax.xml.bind.annotation.adapters;

import org.apache.pulsar.shade.javax.xml.bind.annotation.adapters.XmlAdapter;

public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text) {
        int s2;
        if (text == null) {
            return null;
        }
        int len = text.length();
        for (s2 = 0; s2 < len && !CollapsedStringAdapter.isWhiteSpace(text.charAt(s2)); ++s2) {
        }
        if (s2 == len) {
            return text;
        }
        StringBuilder result = new StringBuilder(len);
        if (s2 != 0) {
            for (int i = 0; i < s2; ++i) {
                result.append(text.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s2 + 1; i < len; ++i) {
            char ch = text.charAt(i);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    @Override
    public String marshal(String s2) {
        return s2;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

