/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.quota.mailing.commands;

import java.util.List;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.CommandHandler;
import org.apache.james.eventsourcing.EventWithState;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.mailbox.quota.mailing.QuotaMailingListenerConfiguration;
import org.apache.james.mailbox.quota.mailing.aggregates.UserQuotaThresholds;
import org.apache.james.mailbox.quota.mailing.commands.DetectThresholdCrossing;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class DetectThresholdCrossingHandler
implements CommandHandler<DetectThresholdCrossing> {
    private final EventStore eventStore;
    private final QuotaMailingListenerConfiguration quotaMailingListenerConfiguration;
    private final String listenerName;

    public DetectThresholdCrossingHandler(EventStore eventStore, QuotaMailingListenerConfiguration quotaMailingListenerConfiguration) {
        this.eventStore = eventStore;
        this.quotaMailingListenerConfiguration = quotaMailingListenerConfiguration;
        this.listenerName = quotaMailingListenerConfiguration.getName();
    }

    public Publisher<List<EventWithState>> handle(DetectThresholdCrossing command) {
        return this.loadAggregate(command).map(aggregate -> aggregate.detectThresholdCrossing(this.quotaMailingListenerConfiguration, command));
    }

    private Mono<UserQuotaThresholds> loadAggregate(DetectThresholdCrossing command) {
        UserQuotaThresholds.Id aggregateId = UserQuotaThresholds.Id.from(command.getUsername(), this.listenerName);
        return Mono.from((Publisher)this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).map(history -> UserQuotaThresholds.fromEvents(aggregateId, history));
    }

    public Class<DetectThresholdCrossing> handledClass() {
        return DetectThresholdCrossing.class;
    }
}

