/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxDAO;
import org.apache.james.mailbox.store.mail.UidProvider;
import reactor.core.publisher.Mono;

public class PostgresUidProvider
implements UidProvider {
    private final PostgresMailboxDAO mailboxDAO;

    public PostgresUidProvider(PostgresMailboxDAO mailboxDAO) {
        this.mailboxDAO = mailboxDAO;
    }

    public MessageUid nextUid(Mailbox mailbox) throws MailboxException {
        return this.nextUid(mailbox.getMailboxId());
    }

    public Optional<MessageUid> lastUid(Mailbox mailbox) {
        return (Optional)this.lastUidReactive(mailbox).block();
    }

    public MessageUid nextUid(MailboxId mailboxId) throws MailboxException {
        return (MessageUid)this.nextUidReactive(mailboxId).blockOptional().orElseThrow(() -> new MailboxException("Error during Uid update"));
    }

    public Mono<Optional<MessageUid>> lastUidReactive(Mailbox mailbox) {
        return this.mailboxDAO.findLastUidByMailboxId(mailbox.getMailboxId()).map(Optional::of).switchIfEmpty(Mono.just(Optional.empty()));
    }

    public Mono<MessageUid> nextUidReactive(MailboxId mailboxId) {
        return this.mailboxDAO.incrementAndGetLastUid(mailboxId, 1).defaultIfEmpty((Object)MessageUid.MIN_VALUE);
    }

    public Mono<List<MessageUid>> nextUids(MailboxId mailboxId, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count need to be positive");
        Mono updateNewLastUid = this.mailboxDAO.incrementAndGetLastUid(mailboxId, count).defaultIfEmpty((Object)MessageUid.MIN_VALUE);
        return updateNewLastUid.map(lastUid -> this.range((MessageUid)lastUid, count));
    }

    private List<MessageUid> range(MessageUid higherInclusive, int count) {
        return (List)LongStream.range(higherInclusive.asLong() - (long)count + 1L, higherInclusive.asLong() + 1L).mapToObj(MessageUid::of).collect(ImmutableList.toImmutableList());
    }

    public static class Factory {
        private final PostgresExecutor.Factory executorFactory;

        public Factory(PostgresExecutor.Factory executorFactory) {
            this.executorFactory = executorFactory;
        }

        public PostgresUidProvider create(MailboxSession session) {
            PostgresExecutor postgresExecutor = this.executorFactory.create(session.getUser().getDomainPart());
            return new PostgresUidProvider(new PostgresMailboxDAO(postgresExecutor));
        }
    }
}

