/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.NaturalIdCacheKey;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.RegionAccessStrategy;
import org.hibernate.engine.spi.SessionImplementor;

public final class CacheHelper {
    private CacheHelper() {
    }

    public static Serializable fromSharedCache(SessionImplementor session, NaturalIdCacheKey cacheKey, NaturalIdRegionAccessStrategy cacheAccessStrategy) {
        return CacheHelper.fromSharedCache(session, (Object)cacheKey, (RegionAccessStrategy)cacheAccessStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Serializable fromSharedCache(SessionImplementor session, Object cacheKey, RegionAccessStrategy cacheAccessStrategy) {
        Serializable cachedValue = null;
        try {
            session.getEventListenerManager().cacheGetStart();
            cachedValue = (Serializable)cacheAccessStrategy.get(cacheKey, session.getTimestamp());
            session.getEventListenerManager().cacheGetEnd(cachedValue != null);
        }
        catch (Throwable throwable) {
            session.getEventListenerManager().cacheGetEnd(cachedValue != null);
            throw throwable;
        }
        return cachedValue;
    }

    public static Serializable fromSharedCache(SessionImplementor session, CacheKey cacheKey, RegionAccessStrategy cacheAccessStrategy) {
        return CacheHelper.fromSharedCache(session, (Object)cacheKey, cacheAccessStrategy);
    }
}

