/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.db.DBReceiver;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class DBReceiverJob
extends ComponentBase
implements Job {
    String sqlException = "SELECT trace_line FROM logging_event_exception where event_id=? ORDER by i ASC";
    String sqlProperties = "SELECT mapped_key, mapped_value FROM logging_event_property WHERE event_id=?";
    String sqlSelect = "SELECT sequence_number, timestamp, rendered_message, logger_name, level_string, ndc, thread_name, reference_flag, caller_filename, caller_class, caller_method, caller_line, event_id FROM logging_event WHERE event_id > ?  ORDER BY event_id ASC";
    long lastId = -32768L;
    DBReceiver parentDBReceiver;

    DBReceiverJob(DBReceiver parent) {
        this.parentDBReceiver = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.getLogger().debug("DBReceiverJob.execute() called");
        Connection connection = null;
        try {
            connection = this.parentDBReceiver.connectionSource.getConnection();
            PreparedStatement statement = connection.prepareStatement(this.sqlSelect);
            statement.setLong(1, this.lastId);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                long id;
                Hashtable properties = new Hashtable();
                long timeStamp = rs.getLong(2);
                String message = rs.getString(3);
                Logger logger = Logger.getLogger(rs.getString(4));
                String level = rs.getString(5);
                Level levelImpl = Level.toLevel(level.trim());
                String ndc = rs.getString(6);
                String threadName = rs.getString(7);
                short mask = rs.getShort(8);
                String fileName = rs.getString(9);
                String className = rs.getString(10);
                String methodName = rs.getString(11);
                String lineNumber = rs.getString(12).trim();
                LocationInfo locationInfo = fileName.equals("?") ? LocationInfo.NA_LOCATION_INFO : new LocationInfo(fileName, className, methodName, lineNumber);
                this.lastId = id = rs.getLong(13);
                ThrowableInformation throwableInfo = null;
                if ((mask & 2) != 0) {
                    throwableInfo = this.getException(connection, id);
                }
                LoggingEvent event = new LoggingEvent(logger.getName(), logger, timeStamp, levelImpl, message, threadName, throwableInfo, ndc, locationInfo, properties);
                event.setProperty("log4jid", Long.toString(id));
                if ((mask & 1) != 0) {
                    this.getProperties(connection, id, event);
                }
                if (this.parentDBReceiver.isPaused()) continue;
                this.parentDBReceiver.doPost(event);
            }
            statement.close();
        }
        catch (SQLException sqle) {
            this.getLogger().error((Object)"Problem receiving events", sqle);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    void getProperties(Connection connection, long id, LoggingEvent event) throws SQLException {
        try (PreparedStatement statement = connection.prepareStatement(this.sqlProperties);){
            statement.setLong(1, id);
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                event.setProperty(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThrowableInformation getException(Connection connection, long id) throws SQLException {
        try (PreparedStatement statement = null;){
            statement = connection.prepareStatement(this.sqlException);
            statement.setLong(1, id);
            ResultSet rs = statement.executeQuery();
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            int len = v.size();
            String[] strRep = new String[len];
            for (int i = 0; i < len; ++i) {
                strRep[i] = (String)v.get(i);
            }
            ThrowableInformation throwableInformation = new ThrowableInformation(strRep);
            return throwableInformation;
        }
    }
}

