/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;

public class TesseractOCRConfig
implements Serializable {
    private static final long serialVersionUID = -4861942486845757891L;
    private String tesseractPath = "";
    private String language = "eng";
    private String pageSegMode = "1";
    private int minFileSizeToOcr = 0;
    private int maxFileSizeToOcr = Integer.MAX_VALUE;
    private int timeout = 120;

    public TesseractOCRConfig() {
        this.init(this.getClass().getResourceAsStream("TesseractOCRConfig.properties"));
    }

    public TesseractOCRConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        this.setTesseractPath(this.getProp(props, "tesseractPath", this.getTesseractPath()));
        this.setLanguage(this.getProp(props, "language", this.getLanguage()));
        this.setPageSegMode(this.getProp(props, "pageSegMode", this.getPageSegMode()));
        this.setMinFileSizeToOcr(this.getProp(props, "minFileSizeToOcr", this.getMinFileSizeToOcr()));
        this.setMaxFileSizeToOcr(this.getProp(props, "maxFileSizeToOcr", this.getMaxFileSizeToOcr()));
        this.setTimeout(this.getProp(props, "timeout", this.getTimeout()));
    }

    public String getTesseractPath() {
        return this.tesseractPath;
    }

    public void setTesseractPath(String tesseractPath) {
        if (!tesseractPath.isEmpty() && !tesseractPath.endsWith(File.separator)) {
            tesseractPath = tesseractPath + File.separator;
        }
        this.tesseractPath = tesseractPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (!language.matches("([A-Za-z](\\+?))*")) {
            throw new IllegalArgumentException("Invalid language code");
        }
        this.language = language;
    }

    public String getPageSegMode() {
        return this.pageSegMode;
    }

    public void setPageSegMode(String pageSegMode) {
        if (!pageSegMode.matches("[1-9]|10")) {
            throw new IllegalArgumentException("Invalid language code");
        }
        this.pageSegMode = pageSegMode;
    }

    public int getMinFileSizeToOcr() {
        return this.minFileSizeToOcr;
    }

    public void setMinFileSizeToOcr(int minFileSizeToOcr) {
        this.minFileSizeToOcr = minFileSizeToOcr;
    }

    public int getMaxFileSizeToOcr() {
        return this.maxFileSizeToOcr;
    }

    public void setMaxFileSizeToOcr(int maxFileSizeToOcr) {
        this.maxFileSizeToOcr = maxFileSizeToOcr;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private int getProp(Properties properties, String property, int defaultMissing) {
        String p = properties.getProperty(property);
        if (p == null || p.isEmpty()) {
            return defaultMissing;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Cannot parse TesseractOCRConfig variable %s, invalid integer value", property), ex);
        }
    }

    private String getProp(Properties properties, String property, String defaultMissing) {
        return properties.getProperty(property, defaultMissing);
    }
}

