/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.mqtt.cs.session;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.mqtt.common.facade.LmqQueueStore;
import org.apache.rocketmq.mqtt.common.model.Queue;
import org.apache.rocketmq.mqtt.common.model.Subscription;
import org.apache.rocketmq.mqtt.cs.session.Session;
import org.springframework.stereotype.Component;

@Component
public class QueueFresh {
    @Resource
    private LmqQueueStore lmqQueueStore;

    public Set<Queue> freshQueue(Session session, Subscription subscription) {
        Set brokers;
        HashSet<Queue> queues = new HashSet<Queue>();
        if (subscription.isP2p()) {
            String findTopic = this.lmqQueueStore.getClientP2pTopic();
            if (StringUtils.isBlank((CharSequence)findTopic)) {
                findTopic = this.lmqQueueStore.getClientRetryTopic();
            }
            brokers = this.lmqQueueStore.getReadableBrokers(findTopic);
        } else {
            brokers = subscription.isRetry() ? this.lmqQueueStore.getReadableBrokers(this.lmqQueueStore.getClientRetryTopic()) : this.lmqQueueStore.getReadableBrokers(subscription.toFirstTopic());
        }
        if (brokers == null || brokers.isEmpty()) {
            return queues;
        }
        for (String broker : brokers) {
            Queue moreQueue = new Queue();
            moreQueue.setQueueName(subscription.toQueueName());
            moreQueue.setBrokerName(broker);
            queues.add(moreQueue);
        }
        session.freshQueue(subscription, queues);
        return queues;
    }
}

