/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty.shaded.io.grpc.netty;

import com.alipay.sofa.jraft.rpc.Connection;
import com.alipay.sofa.jraft.rpc.impl.ConnectionClosedEventListener;
import com.alipay.sofa.jraft.util.internal.ReferenceFieldUpdater;
import com.alipay.sofa.jraft.util.internal.Updaters;
import io.grpc.internal.ServerStream;
import io.grpc.netty.shaded.io.grpc.netty.NettyConnection;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerStream;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.util.Attribute;
import io.grpc.netty.shaded.io.netty.util.AttributeKey;
import java.util.List;

public class NettyConnectionHelper {
    private static final ReferenceFieldUpdater<NettyServerStream, Channel> CHANNEL_GETTER = Updaters.newReferenceFieldUpdater(NettyServerStream.class, (String)"channel");
    private static final AttributeKey<NettyConnection> NETTY_CONN_KEY = AttributeKey.valueOf((String)"netty.conn");

    public static Connection getOrCreateConnection(ServerStream stream, List<ConnectionClosedEventListener> listeners) {
        if (stream instanceof NettyServerStream) {
            return NettyConnectionHelper.attachChannel((Channel)CHANNEL_GETTER.get((Object)((NettyServerStream)stream)), listeners);
        }
        return null;
    }

    private static Connection attachChannel(Channel channel, List<ConnectionClosedEventListener> listeners) {
        NettyConnection newConn;
        if (channel == null) {
            return null;
        }
        Attribute attr = channel.attr(NETTY_CONN_KEY);
        NettyConnection conn = (NettyConnection)attr.get();
        if (conn == null && (conn = (NettyConnection)attr.setIfAbsent((Object)(newConn = new NettyConnection(channel)))) == null) {
            conn = newConn;
            for (ConnectionClosedEventListener l : listeners) {
                conn.addClosedEventListener(l);
            }
        }
        return conn;
    }
}

