/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.serviceregistry.task;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.swagger.models.Swagger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.api.response.GetSchemaResponse;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.apache.servicecomb.serviceregistry.client.http.Holder;
import org.apache.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import org.apache.servicecomb.serviceregistry.task.AbstractRegisterTask;
import org.apache.servicecomb.serviceregistry.task.HeartbeatResult;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceHeartbeatTask;
import org.apache.servicecomb.serviceregistry.task.MicroserviceInstanceRegisterTask;
import org.apache.servicecomb.serviceregistry.task.TaskStatus;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceRegisterTask
extends AbstractRegisterTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceRegisterTask.class);
    private boolean schemaIdSetMatch;

    public MicroserviceRegisterTask(EventBus eventBus, ServiceRegistryClient srClient, Microservice microservice) {
        super(eventBus, srClient, microservice);
        this.taskStatus = TaskStatus.READY;
    }

    public boolean isSchemaIdSetMatch() {
        return this.schemaIdSetMatch;
    }

    @Subscribe
    public void onMicroserviceInstanceHeartbeatTask(MicroserviceInstanceHeartbeatTask task) {
        if (task.getHeartbeatResult() != HeartbeatResult.SUCCESS && this.isSameMicroservice(task.getMicroservice())) {
            LOGGER.info("read MicroserviceInstanceHeartbeatTask status is {}", (Object)task.taskStatus);
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        }
    }

    @Subscribe
    public void onInstanceRegistryFailed(MicroserviceInstanceRegisterTask task) {
        if (task.taskStatus != TaskStatus.FINISHED) {
            LOGGER.info("read MicroserviceInstanceRegisterTask status is {}", (Object)task.taskStatus);
            this.taskStatus = TaskStatus.READY;
            this.registered = false;
        }
    }

    @Override
    protected boolean doRegister() {
        LOGGER.info("running microservice register task.");
        String serviceId = this.srClient.getMicroserviceId(this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getEnvironment());
        if (!StringUtils.isEmpty((CharSequence)serviceId)) {
            this.microservice.setServiceId(serviceId);
            LOGGER.info("Microservice exists in service center, no need to register. id=[{}] appId=[{}], name=[{}], version=[{}], env=[{}]", new Object[]{serviceId, this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getEnvironment()});
            if (!this.checkSchemaIdSet()) {
                return false;
            }
        } else {
            serviceId = this.srClient.registerMicroservice(this.microservice);
            if (StringUtils.isEmpty((CharSequence)serviceId)) {
                LOGGER.error("Registry microservice failed. appId=[{}], name=[{}], version=[{}], env=[{}]", new Object[]{this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getEnvironment()});
                return false;
            }
            LOGGER.info("Registry Microservice successfully. id=[{}] appId=[{}], name=[{}], version=[{}], schemaIds={}, env=[{}]", new Object[]{serviceId, this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getSchemas(), this.microservice.getEnvironment()});
        }
        this.microservice.setServiceId(serviceId);
        this.microservice.getInstance().setServiceId(this.microservice.getServiceId());
        return this.registerSchemas();
    }

    private boolean checkSchemaIdSet() {
        Microservice existMicroservice = this.srClient.getMicroservice(this.microservice.getServiceId());
        if (existMicroservice == null) {
            LOGGER.error("Error to get microservice from service center when check schema set");
            return false;
        }
        HashSet<String> existSchemas = new HashSet<String>(existMicroservice.getSchemas());
        HashSet<String> localSchemas = new HashSet<String>(this.microservice.getSchemas());
        this.schemaIdSetMatch = existSchemas.equals(localSchemas);
        if (!this.schemaIdSetMatch) {
            LOGGER.warn("SchemaIds is different between local and service center. serviceId=[{}] appId=[{}], name=[{}], version=[{}], env=[{}], local schemaIds={}, service center schemaIds={}", new Object[]{this.microservice.getServiceId(), this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getEnvironment(), localSchemas, existSchemas});
            return true;
        }
        LOGGER.info("SchemaIds are equals to service center. serviceId=[{}], appId=[{}], name=[{}], version=[{}], env=[{}], schemaIds={}", new Object[]{this.microservice.getServiceId(), this.microservice.getAppId(), this.microservice.getServiceName(), this.microservice.getVersion(), this.microservice.getEnvironment(), localSchemas});
        return true;
    }

    private boolean registerSchemas() {
        Holder<List<GetSchemaResponse>> scSchemaHolder = this.srClient.getSchemas(this.microservice.getServiceId());
        if (Response.Status.OK.getStatusCode() != scSchemaHolder.getStatusCode()) {
            LOGGER.error("failed to get schemas from service center, statusCode = [{}]", (Object)scSchemaHolder.getStatusCode());
            return false;
        }
        Map<String, GetSchemaResponse> scSchemaMap = this.convertScSchemaMap(scSchemaHolder);
        for (Map.Entry<String, String> localSchemaEntry : this.microservice.getSchemaMap().entrySet()) {
            if (this.registerSchema(scSchemaMap, localSchemaEntry)) continue;
            return false;
        }
        this.checkRemainingSchema(scSchemaMap);
        this.schemaIdSetMatch = true;
        return true;
    }

    private boolean registerSchema(Map<String, GetSchemaResponse> scSchemaMap, Map.Entry<String, String> localSchemaEntry) {
        GetSchemaResponse scSchema = scSchemaMap.get(localSchemaEntry.getKey());
        boolean onlineSchemaExists = scSchema != null;
        LOGGER.info("schemaId [{}] exists [{}], summary exists [{}]", new Object[]{localSchemaEntry.getKey(), onlineSchemaExists, scSchema != null && scSchema.getSummary() != null});
        if (!onlineSchemaExists) {
            return this.registerNewSchema(localSchemaEntry);
        }
        scSchemaMap.remove(localSchemaEntry.getKey());
        return this.compareAndReRegisterSchema(localSchemaEntry, scSchema);
    }

    private boolean registerNewSchema(Map.Entry<String, String> localSchemaEntry) {
        if (this.onlineSchemaIsModifiable()) {
            return this.registerSingleSchema(localSchemaEntry.getKey(), localSchemaEntry.getValue());
        }
        throw new IllegalStateException("There is a schema only existing in local microservice: [" + localSchemaEntry.getKey() + "], which means there are interfaces changed. You need to increment microservice version before deploying, or you can configure service_description.environment=" + "development" + " to work in development environment and ignore this error");
    }

    private boolean compareAndReRegisterSchema(Map.Entry<String, String> localSchemaEntry, GetSchemaResponse scSchema) {
        String scSchemaSummary = this.getScSchemaSummary(scSchema);
        if (null == scSchemaSummary) {
            return this.registerSingleSchema(localSchemaEntry.getKey(), localSchemaEntry.getValue());
        }
        String localSchemaSummary = RegistryUtils.calcSchemaSummary(localSchemaEntry.getValue());
        if (!localSchemaSummary.equals(scSchemaSummary)) {
            Swagger localSwagger;
            Swagger scSwagger;
            if (this.onlineSchemaIsModifiable()) {
                LOGGER.warn("schema[{}]'s content is changed and the current environment is [{}], so re-register it. It's recommended  to change servicecomb_description.version after schema change, or restart consumer to make changes get notified.", (Object)localSchemaEntry.getKey(), (Object)this.microservice.getEnvironment());
                return this.registerSingleSchema(localSchemaEntry.getKey(), localSchemaEntry.getValue());
            }
            String scSchemaContent = this.srClient.getSchema(this.microservice.getServiceId(), scSchema.getSchemaId());
            String localSchemaContent = localSchemaEntry.getValue();
            if (!StringUtils.isEmpty((CharSequence)scSchemaContent) && !StringUtils.isEmpty((CharSequence)localSchemaContent) && (scSwagger = SwaggerUtils.parseSwagger((String)scSchemaContent)).equals((Object)(localSwagger = SwaggerUtils.parseSwagger((String)localSchemaContent)))) {
                return true;
            }
            if (ServiceRegistryConfig.INSTANCE.isIgnoreSwaggerDifference()) {
                LOGGER.warn("service center schema and local schema both are different:\n service center schema:\n[{}]\n local schema:\n[{}]\nYou have configured to ignore difference check. It's recommended to increment microservice version before deploying when schema change.", (Object)scSchemaContent, (Object)localSchemaContent);
                return true;
            }
            LOGGER.warn("service center schema and local schema both are different:\n service center schema:\n[{}\n local schema:\n[{}]", (Object)scSchemaContent, (Object)localSchemaContent);
            String diffStringLocal = StringUtils.difference((String)scSchemaContent, (String)localSchemaContent);
            if (diffStringLocal.equals("")) {
                LOGGER.warn("Some APIs are deleted in local schema which are present in service center schema \n");
            } else {
                LOGGER.warn("The difference in local schema:\n[{}]", (Object)diffStringLocal);
            }
            throw new IllegalStateException("The schema(id=[" + localSchemaEntry.getKey() + "]) content held by this instance and the service center is different. You need to increment microservice version before deploying. Or you can configure service_description.environment=" + "development" + " to work in development environment and ignore this error");
        }
        return true;
    }

    private String getScSchemaSummary(GetSchemaResponse scSchema) {
        String scSchemaSummary = scSchema.getSummary();
        if (null != scSchemaSummary) {
            return scSchemaSummary;
        }
        String onlineSchemaContent = this.srClient.getSchema(this.microservice.getServiceId(), scSchema.getSchemaId());
        if (null != onlineSchemaContent) {
            scSchemaSummary = RegistryUtils.calcSchemaSummary(onlineSchemaContent);
        }
        return scSchemaSummary;
    }

    private void checkRemainingSchema(Map<String, GetSchemaResponse> scSchemaMap) {
        if (!scSchemaMap.isEmpty()) {
            if (!this.onlineSchemaIsModifiable()) {
                throw new IllegalStateException("There are schemas only existing in service center: " + scSchemaMap.keySet() + ", which means there are interfaces changed. You need to increment microservice version before deploying, or if service_description.environment=" + "development" + ", you can delete microservice information in service center and restart this instance.");
            }
            LOGGER.warn("There are schemas only existing in service center: {}, which means there are interfaces changed. It's recommended to increment microservice version before deploying.", scSchemaMap.keySet());
            LOGGER.warn("ATTENTION: The schemas in new version are less than the old version, which may cause compatibility problems.");
        }
    }

    private boolean onlineSchemaIsModifiable() {
        return "development".equalsIgnoreCase(this.microservice.getEnvironment()) || ServiceRegistryConfig.INSTANCE.isAlwaysOverrideSchema();
    }

    private boolean registerSingleSchema(String schemaId, String content) {
        return this.srClient.registerSchema(this.microservice.getServiceId(), schemaId, content);
    }

    private Map<String, GetSchemaResponse> convertScSchemaMap(Holder<List<GetSchemaResponse>> scSchemaHolder) {
        HashMap<String, GetSchemaResponse> scSchemaMap = new HashMap<String, GetSchemaResponse>();
        List<GetSchemaResponse> scSchemaList = scSchemaHolder.getValue();
        if (null == scSchemaList) {
            return scSchemaMap;
        }
        for (GetSchemaResponse scSchema : scSchemaList) {
            scSchemaMap.put(scSchema.getSchemaId(), scSchema);
        }
        return scSchemaMap;
    }
}

