/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.Subject;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.oak.spi.security.authentication.AuthInfoImpl;
import org.apache.jackrabbit.oak.spi.security.principal.AdminPrincipal;
import org.apache.jackrabbit.oak.spi.security.principal.SystemUserPrincipal;
import org.apache.sling.jcr.base.AbstractSlingRepository2;
import org.apache.sling.jcr.base.AbstractSlingRepositoryManager;
import org.osgi.framework.Bundle;

public class OakSlingRepository
extends AbstractSlingRepository2 {
    private final String adminId;

    private static String first(Iterable<String> servicePrincipalNames) {
        Iterator<String> iterator = servicePrincipalNames.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    protected OakSlingRepository(AbstractSlingRepositoryManager manager, Bundle usingBundle, String adminId) {
        super(manager, usingBundle);
        this.adminId = adminId;
    }

    protected Session createAdministrativeSession(String workspace) throws RepositoryException {
        Set<AdminPrincipal> principals = Collections.singleton(() -> this.adminId);
        AuthInfoImpl authInfo = new AuthInfoImpl(this.adminId, Collections.emptyMap(), principals);
        Subject subject = new Subject(true, principals, Collections.singleton(authInfo), Collections.emptySet());
        try {
            return Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

                @Override
                public Session run() throws Exception {
                    HashMap<String, Integer> attrs = new HashMap<String, Integer>();
                    attrs.put("oak.refresh-interval", 0);
                    return OakSlingRepository.this.getJackrabbitRepository().login(null, null, attrs);
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            throw new RepositoryException("failed to retrieve admin session.", (Throwable)e);
        }
    }

    protected Session createServiceSession(Iterable<String> servicePrincipalNames, final String workspaceName) throws RepositoryException {
        HashSet<SystemUserPrincipal> principals = new HashSet<SystemUserPrincipal>();
        for (String pName : servicePrincipalNames) {
            principals.add(() -> pName);
        }
        AuthInfoImpl authInfo = new AuthInfoImpl(OakSlingRepository.first(servicePrincipalNames), Collections.emptyMap(), principals);
        Subject subject = new Subject(true, principals, Collections.singleton(authInfo), Collections.emptySet());
        try {
            return Subject.doAsPrivileged(subject, new PrivilegedExceptionAction<Session>(){

                @Override
                public Session run() throws Exception {
                    return OakSlingRepository.this.getRepository().login(null, workspaceName);
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            throw new RepositoryException("failed to retrieve service session.", (Throwable)e);
        }
    }

    private JackrabbitRepository getJackrabbitRepository() {
        return (JackrabbitRepository)super.getRepository();
    }
}

