/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import java.io.UnsupportedEncodingException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.sling.testing.tools.http.RequestCustomizer;

public class Request {
    private final HttpUriRequest request;
    private String username;
    private String password;
    private boolean redirects = true;
    private RequestCustomizer customizer;

    Request(HttpUriRequest r) {
        this.request = r;
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.request.getURI();
    }

    public Request withHeader(String name, String value) {
        this.request.addHeader(name, value);
        return this;
    }

    public Request withCredentials(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public Request withRedirects(boolean followRedirectsAutomatically) {
        this.redirects = followRedirectsAutomatically;
        return this;
    }

    private HttpEntityEnclosingRequestBase getHttpEntityEnclosingRequestBase() {
        if (this.request instanceof HttpEntityEnclosingRequestBase) {
            return (HttpEntityEnclosingRequestBase)this.request;
        }
        throw new IllegalStateException("Request is not an HttpEntityEnclosingRequestBase: " + this.request.getClass().getName());
    }

    public Request withContent(String content) throws UnsupportedEncodingException {
        return this.withEntity((HttpEntity)new StringEntity(content, "UTF-8"));
    }

    public Request withEntity(HttpEntity e) throws UnsupportedEncodingException {
        this.getHttpEntityEnclosingRequestBase().setEntity(e);
        return this;
    }

    public Request withCustomizer(RequestCustomizer c) {
        this.customizer = c;
        return this;
    }

    void customizeIfNeeded() {
        if (this.customizer != null) {
            this.customizer.customizeRequest(this);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getRedirects() {
        return this.redirects;
    }

    public RequestCustomizer getCustomizer() {
        return this.customizer;
    }
}

