/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.language.translator;

import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.language.translator.AbstractTranslateVisitor;
import org.apache.tinkerpop.gremlin.language.translator.TranslatorException;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceVertex;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;

public class JavaTranslateVisitor
extends AbstractTranslateVisitor {
    private static final String vertexClassName = ReferenceVertex.class.getSimpleName();

    public JavaTranslateVisitor() {
        super("g");
    }

    public JavaTranslateVisitor(String graphTraversalSourceName) {
        super(graphTraversalSourceName);
    }

    @Override
    public Void visitStructureVertex(GremlinParser.StructureVertexContext ctx) {
        this.sb.append("new ");
        this.sb.append(vertexClassName);
        this.sb.append("(");
        this.visit(ctx.getChild(3));
        this.sb.append(", ");
        this.visit(ctx.getChild(5));
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitTraversalStrategy(GremlinParser.TraversalStrategyContext ctx) {
        if (ctx.getChildCount() == 1) {
            this.sb.append(ctx.getText()).append(".instance()");
        } else {
            this.visit((ParseTree)ctx.classType());
            this.sb.append(".build()");
            List configs = ctx.children.stream().filter(c -> c instanceof GremlinParser.ConfigurationContext).collect(Collectors.toList());
            for (ParseTree config : configs) {
                this.sb.append(".");
                this.visit(config);
            }
            this.sb.append(".create()");
        }
        return null;
    }

    @Override
    public Void visitConfiguration(GremlinParser.ConfigurationContext ctx) {
        this.sb.append(ctx.getChild(0).getText()).append("(");
        this.visit(ctx.getChild(2));
        this.sb.append(")");
        return null;
    }

    @Override
    public Void visitClassType(GremlinParser.ClassTypeContext ctx) {
        if (ctx.getParent() instanceof GremlinParser.TraversalSourceSelfMethod_withoutStrategiesContext || ctx.getParent() instanceof GremlinParser.ClassTypeExprContext) {
            this.sb.append(ctx.getText()).append(".class");
        } else {
            this.sb.append(ctx.getText());
        }
        return null;
    }

    @Override
    public Void visitGenericLiteralMap(GremlinParser.GenericLiteralMapContext ctx) {
        this.sb.append("new LinkedHashMap<Object, Object>() {{ ");
        for (int i = 0; i < ctx.mapEntry().size(); ++i) {
            GremlinParser.MapEntryContext mapEntryContext = ctx.mapEntry(i);
            this.visit((ParseTree)mapEntryContext);
            if (i >= ctx.mapEntry().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }

    @Override
    public Void visitMapEntry(GremlinParser.MapEntryContext ctx) {
        this.sb.append("put(");
        boolean isKeyWrappedInParens = ctx.getChild(0).getText().equals("(");
        if (ctx.getChild(0) instanceof TerminalNode && !isKeyWrappedInParens) {
            this.handleStringLiteralText(ctx.getChild(0).getText());
        } else {
            int indexOfActualKey = isKeyWrappedInParens ? 1 : 0;
            this.visit(ctx.getChild(indexOfActualKey));
        }
        this.sb.append(", ");
        int indexOfValue = isKeyWrappedInParens ? 4 : 2;
        this.visit(ctx.getChild(indexOfValue));
        this.sb.append(");");
        return null;
    }

    @Override
    public Void visitDateLiteral(GremlinParser.DateLiteralContext ctx) {
        String dtString = ctx.getChild(2).getText();
        OffsetDateTime dt = DatetimeHelper.parse(JavaTranslateVisitor.removeFirstAndLastCharacters(dtString));
        this.sb.append("OffsetDateTime.parse(\"");
        this.sb.append(dt);
        this.sb.append("\")");
        return null;
    }

    @Override
    public Void visitNanLiteral(GremlinParser.NanLiteralContext ctx) {
        this.sb.append("Double.NaN");
        return null;
    }

    @Override
    public Void visitInfLiteral(GremlinParser.InfLiteralContext ctx) {
        if (ctx.SignedInfLiteral().getText().equals("-Infinity")) {
            this.sb.append("Double.NEGATIVE_INFINITY");
        } else {
            this.sb.append("Double.POSITIVE_INFINITY");
        }
        return null;
    }

    @Override
    public Void visitIntegerLiteral(GremlinParser.IntegerLiteralContext ctx) {
        String integerLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = integerLiteral.length() - 1;
        char lastCharacter = integerLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'b': {
                this.sb.append("new Byte(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 's': {
                this.sb.append("new Short(");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append(")");
                break;
            }
            case 'i': {
                this.sb.append(integerLiteral, 0, lastCharIndex);
                break;
            }
            case 'l': {
                this.sb.append(integerLiteral);
                break;
            }
            case 'n': {
                this.sb.append("new BigInteger(\"");
                this.sb.append(integerLiteral, 0, lastCharIndex);
                this.sb.append("\")");
                break;
            }
            default: {
                this.sb.append(integerLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitFloatLiteral(GremlinParser.FloatLiteralContext ctx) {
        String floatLiteral = ctx.getText().toLowerCase();
        int lastCharIndex = floatLiteral.length() - 1;
        char lastCharacter = floatLiteral.charAt(lastCharIndex);
        switch (lastCharacter) {
            case 'd': 
            case 'f': {
                this.sb.append(floatLiteral);
                break;
            }
            case 'm': {
                this.sb.append("new BigDecimal(\"");
                this.sb.append(floatLiteral, 0, lastCharIndex);
                this.sb.append("\")");
                break;
            }
            default: {
                this.sb.append(floatLiteral);
            }
        }
        return null;
    }

    @Override
    public Void visitGenericLiteralRange(GremlinParser.GenericLiteralRangeContext ctx) {
        throw new TranslatorException("Java does not support range literals");
    }

    @Override
    public Void visitGenericLiteralSet(GremlinParser.GenericLiteralSetContext ctx) {
        this.sb.append("new HashSet<Object>() {{ ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.sb.append("add(");
            this.visit((ParseTree)genericLiteralContext);
            this.sb.append(");");
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }

    @Override
    public Void visitGenericLiteralCollection(GremlinParser.GenericLiteralCollectionContext ctx) {
        this.sb.append("new ArrayList<Object>() {{ ");
        for (int i = 0; i < ctx.genericLiteral().size(); ++i) {
            GremlinParser.GenericLiteralContext genericLiteralContext = ctx.genericLiteral(i);
            this.sb.append("add(");
            this.visit((ParseTree)genericLiteralContext);
            this.sb.append(");");
            if (i >= ctx.genericLiteral().size() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }

    @Override
    public Void visitStringLiteralList(GremlinParser.StringLiteralListContext ctx) {
        this.sb.append("new ArrayList<String>() {{ ");
        for (int ix = 0; ix < ctx.getChild(1).getChildCount(); ++ix) {
            if (ctx.getChild(1).getChild(ix) instanceof TerminalNode) continue;
            this.sb.append("add(");
            this.visit(ctx.getChild(1).getChild(ix));
            this.sb.append(");");
            if (ix >= ctx.getChild(1).getChildCount() - 1) continue;
            this.sb.append(" ");
        }
        this.sb.append(" }}");
        return null;
    }
}

