/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.util;

import jakarta.activation.DataSource;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.internet.ParseException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayDataSource
implements DataSource {
    private final byte[] source;
    private final String contentType;
    private String name = "";

    public ByteArrayDataSource(InputStream in, String type) throws IOException {
        int bytesRead;
        ByteArrayOutputStream sink = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((bytesRead = in.read(buffer)) > 0) {
            sink.write(buffer, 0, bytesRead);
        }
        this.source = sink.toByteArray();
        this.contentType = type;
    }

    public ByteArrayDataSource(byte[] data, String type) {
        this.source = data;
        this.contentType = type;
    }

    public ByteArrayDataSource(String data, String type) throws IOException {
        String charset = null;
        try {
            ContentType content = new ContentType(type);
            charset = content.getParameter("charset");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        charset = charset == null ? MimeUtility.getDefaultJavaCharset() : MimeUtility.javaCharset(charset);
        this.source = data.getBytes(charset);
        this.contentType = type;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.source);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("Writing to a ByteArrayDataSource is not supported");
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

