#!BPY
# -*- coding: latin-1 -*-
"""
Name: 'Head Creator'
Blender: 248
Group: 'Add'
Tooltip: 'Create a Head'
"""

__author__ = ["Sam B"]
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Add/Head_Creator")
__version__ = "248 - 2008-10"

__bpydoc__ = """\
This Script Makes a Low Poly Half Head. 
.\n\
"""

#-------------------------------------
# HEAD CREATOR v0.3b - 2009.01.05
#(c) Sam B,  2000
#dirtysound@wanadoo.fr
#http://www.chez.com/blenderconnection
#-------------------------------------
#
# ***** BEGIN GPL LICENSE BLOCK ***** 
# 
# This program is free software; you can redistribute it and/or 
# modify it under the terms of the GNU General Public License 
# as published by the Free Software Foundation; either version 2 
# of the License, or (at your option) any later version. 
# 
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
# GNU General Public License for more details. 
# 
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, 
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 
# 
# ***** END GPL LICENCE BLOCK ***** 
#
# -------------------------------------------------------------------------- 
# ---------------------------------------------------------
# This version of Head Creator had been written with Blender
# 1.8 and works well with 2.x
# The gfx interface has lot of news sliders, for this reason,
# it takes more place on the screen. You must use this script
# with a 1024*768 minimal resolution.
#
# You can distribute free the script, but can't sell it. 
#
# Utilisation of this script is at your own risk.I'm not
# reponsable if your computer explode :))
#
# 2000.11.25 by Sam B 
# 2009.01.05 modif for 2.48 by Remigiusz Fiedler (AKA migius)
# ---------------------------------------------------------
#
# To start the script, press Alt + p
# Move the sliders and click on MAKE
# Print the help file for infos on buttons 
# 
# Have fun !!!
#
# ---------------------------------------------------------


# -----------
#init modules
# -----------

import Blender
from Blender import NMesh
from Blender.Draw import *
from Blender.BGL import *
import math
from math import *

# ================================================================



# ------------------------
# liste des modificateurs 
# ------------------------

# Sizex=sx; Sizey=sy; Sizez=sz; 1/2upsizex=dhsx; 1/2upsizey=dhsy; 1/2upsizez=dhsz; 1/2downsizex=dbsx; 1/2downsizey=dbsy; 1/2downsizez=dbsz
# 1/2midsizex=dmsx; 1/2midsizey=dmsy; 1/2midsizez=dmsz; 1/2mdlocx=dmlx; 1/2midlocy=dmly; 1/2modlocz=dmlz; 1/2uplocx=dhlx; 1/2uplocy=dhly; 1/2uplocz=dhlz
# 1/2downlocx=dblx; 1/2downlocy=dbly; 1/2downlocz=dblz; eyesizex=esx; eyesizey=esy; eyesizez=esz; eyelocx=elx; eyelocy=ely; eyelocz=elz
# mentonsizex=msx: mentonsizey=msy; mentonsizez=msz; mentonlocx=mlx; mentonlocy=mly; mentonsizez=mlz; mentonbaslocy=mbly;
# pommettesizex=psx; ...y=psy; ...z=psz; pommettelocx=plx; ...y=ply; ...z=plz; bouchesizex=bsx; ...y=bsy; ...z=bsz,bouchelocx=blx; ...y=bly; ...z=blz
# nezupsizex=nhsx; ...y=nhsy; ...z=nhsz; nezdownsizex=nbsx; ...y=nbsy; ...z=nbsz; nezlocx=nlx; ...y=nly; ...z=nlz; nezcurvey=ncy; ...z=ncz;

# ================================================================

# ------------------
# init modificateurs
# ------------------


sx=Create(1.0)
sy=Create(1.0)
sz=Create(1.0)
dhsx=Create(1.0)
dhsy=Create(1.0)
dhsz=Create(1.0)
dbsx=Create(1.0)
dbsy=Create(1.0)
dbsz=Create(1.0)
dmsx=Create(1.0)
dmsy=Create(1.0)
dmsz=Create(1.0)
dmlx=Create(0.0)
dmly=Create(0.0)
dmlz=Create(0.0)
dhlx=Create(0.0)
dhly=Create(0.0)
dhlz=Create(0.0)
dblx=Create(0.0)
dbly=Create(0.0)
dblz=Create(0.0)
esx=Create(1.0)
esy=Create(1.0)
esz=Create(1.0)
elx=Create(0.0)
ely=Create(0.0)
elz=Create(0.0)
msx=Create(1.0)
msy=Create(1.0)
msz=Create(1.0)
mlx=Create(0.0)
mly=Create(0.0)
mlz=Create(0.0)
mbly=Create(0.0)
psx=Create(1.0)
psy=Create(1.0)
psz=Create(1.0)
plx=Create(0.0)
ply=Create(0.0)
plz=Create(0.0)
bsx=Create(1.0)
bsy=Create(1.0)
bsz=Create(1.0)
blx=Create(0.0)
bly=Create(0.0)
blz=Create(0.0)
nhsx=Create(1.0)
nhsy=Create(1.0)
nhsz=Create(1.0)
nbsx=Create(1.0)
nbsy=Create(1.0)
nbsz=Create(1.0)
nlx=Create(0.0)
nly=Create(0.0)
nlz=Create(0.0)
ncy=Create(0.0)
ncz=Create(0.0)
meshname=Create("head")

# ================================================================



# ------------------------
# redef commandes
# ------------------------

glpos=glRasterPos2d
glc=glColor3f
glr=glRectf

# ------------------------
# init interface graphique
# ------------------------


def draw():
	global sx,sy,sz,dhsx,dhsy,dhsz,dbsx,dbsy,dbsz,dmsx,dmsy,dmsz,dmlx,dmly,dmlz,dhlx,dhly,dhlz,dblx,dbly,dblz,esx,esy,esz,elx,ely,elz,msx,msy,msz,mlx,mly,mlz,mbly,psx,psy,psz,plx,ply,plz,bsx,bsy,bsz,blx,bly,blz,nhsx,nhsy,nhsz,nbsx,nbsy,nbsz,nlx,nly,nlz,ncy,ncz,meshname
	glClearColor(0.0, 0.0, 0.0, 0.0)
	glClear(GL_COLOR_BUFFER_BIT)

# --- Pour le fun ---
	glc(0.588, 0.618, 0.545)
	glr(0,0,450,680)
	glc(0.273,0.470,0.424)
	glr(0,640,450,680)
	glr(0,0,450,40)

# --- Creation des boutons ---

# --- 1 --- Creation des boutons concernant la taille generale, les tailles par tiers et les positions des tiers (loc)
	sx=Slider("sx : ", 2, 0, 600, 150, 15, sx.val, 0.5, 2)
	sy=Slider("sy : ", 2, 150, 600, 150, 15, sy.val, 0.5, 2)
	sz=Slider("sz : ", 2, 300, 600, 150, 15, sz.val, 0.5, 2)

	dhsx=Slider("husx : ", 2, 0, 585, 150, 15, dhsx.val, 0.5, 2)
	dhsy=Slider("husy : ", 2, 150, 585, 150, 15, dhsy.val, 0.5, 2)
	dhsz=Slider("husz : ", 2, 300, 585, 150, 15, dhsz.val, 0.5, 2)

	dmsx=Slider("hmsx : ", 2, 0, 570, 150, 15, dmsx.val, 0.5, 2)
	dmsy=Slider("hmsy : ", 2, 150, 570, 150, 15, dmsy.val, 0.5, 2)
	dmsz=Slider("hmsz : ", 2, 300, 570, 150, 15, dmsz.val, 0.5, 2)

	dbsx=Slider("hdsx : ", 2, 0, 555, 150, 15, dbsx.val, 0.5, 2)
	dbsy=Slider("hdsy : ", 2, 150, 555, 150, 15, dbsy.val, 0.5, 2)
	dbsz=Slider("hdsz : ", 2, 300, 555, 150, 15, dbsz.val, 0.5, 2)

	dhlx=Slider("hulx : ", 2, 0, 540, 150, 15, dhlx.val, -1, 1)
	dhly=Slider("huly : ", 2, 150, 540, 150, 15, dhly.val, -1, 1)
	dhlz=Slider("hulz : ", 2, 300, 540, 150, 15, dhlz.val, -1, 1)

	dmlx=Slider("hmlx : ", 2, 0, 525, 150, 15, dmlx.val, -1, 1)
	dmly=Slider("hmly : ", 2, 150, 525, 150, 15, dmly.val, -1, 1)
	dmlz=Slider("hmlz : ", 2, 300, 525, 150, 15, dmlz.val, -1, 1)

	dblx=Slider("hdlx : ", 2, 0, 510, 150, 15, dblx.val, -1, 1)
	dbly=Slider("hdly : ", 2, 150, 510, 150, 15, dbly.val, -1, 1)
	dblz=Slider("hdlz : ", 2, 300, 510, 150, 15, dblz.val, -1, 1)

# --- 2 --- Creation des boutons relatifs a la taille et la position des yeux
	esx=Slider("esx : ", 2, 0, 465, 150, 15, esx.val, 0.5, 2)
	esy=Slider("esy : ", 2, 150, 465, 150, 15, esy.val, 0.5, 2)
	esz=Slider("esz : ", 2, 300, 465, 150, 15, esz.val, 0.9, 1.1)

	elx=Slider("elx : ", 2, 0, 450, 150, 15, elx.val, -1, 1)
	ely=Slider("ely : ", 2, 150, 450, 150, 15, ely.val, -1, 1)
	elz=Slider("elz : ", 2, 300, 450, 150, 15, elz.val, -1, 1)

# --- 3 --- Creation des boutons relatifs a la taille et la position du menton puis sa rotation (emule par deplacement du bas du menton)
	msx=Slider("csx : ", 2, 0, 405, 150, 15, msx.val, 0.5, 2)
	msy=Slider("csy : ", 2, 150, 405, 150, 15, msy.val, 0.5, 2)
	msz=Slider("csz : ", 2, 300, 405, 150, 15, msz.val, 0.5, 2)

	mlx=Slider("clx : ", 2, 0, 390, 150, 15, mlx.val, -1, 1)
	mly=Slider("cly : ", 2, 150, 390, 150, 15, mly.val, -1, 1)
	mlz=Slider("clz : ", 2, 300, 390, 150, 15, mlz.val, -1, 1)

	mbly=Slider("cdly : ", 2, 150, 375, 150, 15, mbly.val, -1, 1)

# --- 4 --- Creation des boutons relatifs a la taille et la position des pommettes

	psx=Slider("cbsx : ", 2, 0, 330, 150, 15, psx.val, 0.5, 2)
	psy=Slider("cbsy : ", 2, 150, 330, 150, 15, psy.val, 0.5, 2)
	psz=Slider("cbsz : ", 2, 300, 330, 150, 15, psz.val, 0.5, 2)

	plx=Slider("cblx : ", 2, 0, 315, 150, 15, plx.val, -1, 1)
	ply=Slider("cbly : ", 2, 150, 315, 150, 15, ply.val, -1, 1)
	plz=Slider("cblz : ", 2, 300, 315, 150, 15, plz.val, -1, 1)

# --- 5 --- Creation des boutons relatifs a la taille et a la position de la bouche

	bsx=Slider("msx : ", 2, 0, 270, 150, 15, bsx.val, 0.5, 2)
	bsy=Slider("msy : ", 2, 150, 270, 150, 15, bsy.val, 0.5, 2)
	bsz=Slider("msz : ", 2, 300, 270, 150, 15, bsz.val, 0.5, 2)

	blx=Slider("mlx : ", 2, 0, 255, 150, 15, blx.val, -1, 1)
	bly=Slider("mly : ", 2, 150, 255, 150, 15, bly.val, -1, 1)
	blz=Slider("mlz : ", 2, 300, 255, 150, 15, blz.val, -1, 1)

# --- 6 --- Creation des boutons relatifs a la taille et la position du nez puis la simulation de la "courbure" du nez

	nhsx=Slider("nusx : ", 2, 0, 210, 150, 15, nhsx.val, 0.5, 2)
	nhsy=Slider("nusy : ", 2, 150, 210, 150, 15, nhsy.val, 0.5, 2)
	nhsz=Slider("nusz : ", 2, 300, 210, 150, 15, nhsz.val, 0.5, 2)

	nbsx=Slider("ndsx : ", 2, 0, 195, 150, 15, nbsx.val, 0.5, 2)
	nbsy=Slider("ndsy : ", 2, 150, 195, 150, 15, nbsy.val, 0.5, 2)
	nbsz=Slider("ndsz : ", 2, 300, 195, 150, 15, nbsz.val, 0.5, 2)

	nlx=Slider("nlx : ", 2, 0, 180, 150, 15, nlx.val, -1, 1)
	nly=Slider("nly : ", 2, 150, 180, 150, 15, nly.val, -1, 1)
	nlz=Slider("nlz : ", 2, 300, 180, 150, 15, nlz.val, -1, 1)

	ncy=Slider("ncy : ", 2, 75, 165, 150, 15, ncy.val, -1, 1)
	ncz=Slider("ncz : ", 2, 225, 165, 150, 15, ncz.val, -1, 1)

# --- 7 --- Mise en place des legendes
	glc(0.073,0.270,0.224)
	glpos(5,625)
	Text("General : size and position / divide in three parts")
	glpos(5,490)
	Text("Eyes : size and position")
	glpos(5,430)
	Text("Chin : Size and position / rotation of the lower part")
	glpos(5,355)
	Text("Cheekbones : Size and position")
	glpos(5,295)
	Text("Mouth : Size and position")
	glpos(5,235)
	Text("Nose : Size and position / nose curve simulation")

# --- 8 --- Pour le fun (suite)
	
	glc(0.588, 0.618, 0.545)
	glr(140,645,150,670)
	glr(140,655,160,660)
	glr(160,645,170,670)
	glpos(175,645)
	Text("EAD")
	glr(205,645,230,650)
	glr(205,645,215,665)
	glr(205,665,230,670)
	glpos(235,645)
	Text("REATOR   v0.3")
	glpos(5,25)
	Text("Contact : dirtysound@wanadoo.fr")
	glpos(60,5)
	Text("http://www.chez.com/blenderconnection")
	glr(300,0,305,40)
	glpos(315,25)
	Text("Head Creator v0.3")
	glpos(315,5)
	Text("(c) Sam B 2000")



# --- 9 --- Creation des boutons de sortie et definition des event et bevent

	Button("Exit", 1, 150, 75, 75, 20)
	Button("Make", 5, 225, 75, 75, 20)
	meshname=String("Mesh name : ", 2, 150, 55, 150, 20, meshname.val, 15)

def event(evt, val):
	if (evt== QKEY and not val): 
	  Exit()

def bevent(evt):
	global sx,sy,sz,dhsx,dhsy,dhsz,dbsx,dbsy,dbsz,dmsx,dmsy,dmsz,dmlx,dmly,dmlz,dhlx,dhly,dhlz,dblx,dbly,dblz,esx,esy,esz,elx,ely,elz,msx,msy,msz,mlx,mly,mlz,mbly,psx,psy,psz,plx,ply,plz,bsx,bsy,bsz,blx,bly,blz,nhsx,nhsy,nhsz,nbsx,nbsy,nbsz,nlx,nly,nlz,ncy,ncz,meshname
	if (evt==1):
	   Exit()
	elif(evt==5):
	   tete(sx.val,sy.val,sz.val,dhsx.val,dhsy.val,dhsz.val,dbsx.val,dbsy.val,dbsz.val,dmsx.val,dmsy.val,dmsz.val,dmlx.val,dmly.val,dmlz.val,dhlx.val,dhly.val,dhlz.val,dblx.val,dbly.val,dblz.val,esx.val,esy.val,esz.val,elx.val,ely.val,elz.val,msx.val,msy.val,msz.val,mlx.val,mly.val,mlz.val,mbly.val,psx.val,psy.val,psz.val,plx.val,ply.val,plz.val,bsx.val,bsy.val,bsz.val,blx.val,bly.val,blz.val,nhsx.val,nhsy.val,nhsz.val,nbsx.val,nbsy.val,nbsz.val,nlx.val,nly.val,nlz.val,ncy.val,ncz.val,meshname)

Register(draw, event, bevent)


# --- fin de la creation de l'interface graphique ---

# ------------------
# Creation du visage 
# ------------------



def tete(sx,sy,sz,dhsx,dhsy,dhsz,dbsx,dbsy,dbsz,dmsx,dmsy,dmsz,dmlx,dmly,dmlz,dhlx,dhly,dhlz,dblx,dbly,dblz,esx,esy,esz,elx,ely,elz,msx,msy,msz,mlx,mly,mlz,mbly,psx,psy,psz,plx,ply,plz,bsx,bsy,bsz,blx,bly,blz,nhsx,nhsy,nhsz,nbsx,nbsy,nbsz,nlx,nly,nlz,ncy,ncz,meshname):

	me=NMesh.GetRaw()
	me.hasVertexUV(0)
	#me.has_uvco=0
	me.hasVertexColours(0)
	#me.has_col=0

	nom=meshname.val

# --- 1 --- Creation des sommets en fonctions des valeurs de l'interface


#5
	s=NMesh.Vert(1.230368*sx*dmsx*esx+dmlx+elx,-1.785640*sy*dmsy*esy+dmly+ely,1.167973*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.802382*sx*dmsx*esx+dmlx+elx,-1.994290*sy*dmsy*esy+dmly+ely,1.037963*sz*dmsz*1/esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.630408*sx*dbsx*bsx+blx+dblx,-2.024313*sy*dbsy*bsy+bly+dbly,-0.357183*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.484583*sx*dbsx*bsx+blx+dblx,-2.124016*sy*dbsy*bsy+bly+dbly,-0.355713*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.437487*sx*dbsx*bsx+blx+dblx,-2.122846*sy*dbsy*bsy+bly+dbly,-0.398200*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)

#10
	s=NMesh.Vert(0.270328*sx*dbsx*bsx+blx+dblx,-2.274496*sy*dbsy*bsy+bly+dbly,-0.320126*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.265148*sx*dbsx*bsx+blx+dblx,-2.241182*sy*dbsy*bsy+bly+dbly,-0.421764*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx*bsx,-2.362415*sy*dbsy*bsy+bly+dbly,-0.322557*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.300571*sx*dbsx*bsx+blx+dblx,-2.206066*sy*dbsy*bsy+bly+dbly,-0.548971*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx*bsx,-2.273838*sy*dbsy*bsy+bly+dbly,-0.567033*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)

#15
	s=NMesh.Vert(-0.00*sx*dbsx*bsx,-2.295560*sy*dbsy*bsy+bly+dbly,-0.439659*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,-0.172342*sy*dhsy+dhly,3.546351*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dhsx,-0.643234*sy*dhsy+dhly,3.461251*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.445064*sx*dhsx+dhlx,-0.486852*sy*dhsy+dhly,3.461251*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.697786*sx*dhsx+dhlx,-0.138133*sy*dhsy+dhly,3.461241*sz*dhsz+dhlz)
	me.verts.append(s)

#20
	s=NMesh.Vert(0.493484*sx*dhsx+dhlx,0.239374*sy*dhsy+dhly,3.461244*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.972287*sx*dhsx+dhlx,-1.182938*sy*dhsy+dhly,2.944642*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,0.383378*sy*dhsy+dhly,3.461244*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,-1.712946*sy*dhsy+dhly,2.943184*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.428182*sx*dhsx+dhlx,0.084236*sy*dhsy+dhly,2.948001*sz*dhsz+dhlz)
	me.verts.append(s)

#25
	s=NMesh.Vert(1.095660*sx*dhsx+dhlx,1.104302*sy*dhsy+dhly,3.022115*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,1.440912*sy*dhsy+dhly,3.026871*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.321351*sx*dhsx+dhlx,-1.681725*sy*dhsy+dhly,2.267291*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.782283*sx*dhsx+dhlx,-0.071645*sy*dhsy+dhly,2.237088*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,-2.208979*sy*dhsy+dhly,2.247503*sz*dhsz+dhlz)
	me.verts.append(s)

#30
	s=NMesh.Vert(1.423980*sx*dhsx+dhlx,1.431647*sy*dhsy+dhly,2.328913*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.426994*sx*dhsx+dhlx,-1.780677*sy*dhsy+dhly,1.626298*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,2.062148*sy*dhsy+dhly,2.327049*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,-2.293853*sy*dhsy+dhly,1.736966*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.603508*sx*dmsx+dmlx,-2.205923*sy*dmsy+dmly,1.566363*sz*dmsz+dmlz)
	me.verts.append(s)

#35
	s=NMesh.Vert(1.343480*sx*dmsx+dmlx,-1.813852*sy*dmsy+dmly,1.436480*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(1.857917*sx*dhsx+dhlx,-0.155222*sy*dhsy+dhly,1.096920*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.562398*sx*dhsx+dhlx,1.384082*sy*dhsy+dhly,1.109286*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(0.194400*sx*dmsx*1/esx*nhsx+nlx+dmlx+elx,-2.123449*sy*dmsy*esy*nhsy+nly+dmly+ely,1.326094*sz*dmsz*esz*nhsz+nlz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.345054*sx*dmsx*1/esx+dmlx+elx,-1.980986*sy*dmsy*esy+dmly+ely,1.302872*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)

#40
	s=NMesh.Vert(0.602801*sx*dmsx*1/esx+dmlx+elx,-2.095353*sy*dmsy*esy+dmly+ely,1.398568*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.946455*sx*dmsx*esx+dmlx+elx,-1.964319*sy*dmsy*esy+dmly+ely,1.366756*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dhsx,2.086112*sy*dhsy+dhly,1.118804*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx*nhsx,-2.272186*sy*dmsy*nhsy+nly+dmly,1.331596*sz*dmsz*nhsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(1.605877*sx*dmsx+dmlx,-1.354944*sy*dmsy+dmly,1.046731*sz*dmsz+dmlz)
	me.verts.append(s)

#45
	s=NMesh.Vert(0.625367*sx*dmsx*1/esx+dmlx+elx,-2.002353*sy*dmsy*esy+dmly+ely,1.329929*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.915846*sx*dmsx*esx+dmlx+elx,-1.955218*sy*dmsy*esy+dmly+ely,1.300021*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(1.239251*sx*dmsx*esx+dmlx+elx,-1.732887*sy*dmsy*esy+dmly+ely,1.230045*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.289462*sx*dmsx*1/esx*nhsx+nlx+dmlx+elx,-1.984781*sy*dmsy*esy*nhsy+nly+dmly+ely,1.144546*sz*dmsz*esz*nhsz+nlz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.369023*sx*dmsx*1/esx+dmlx+elx,-1.913524*sy*dmsy*esy+dmly+ely,1.195832*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)

#50
	s=NMesh.Vert(1.234240*sx*dmsx*esx+dmlx+elx,-1.754877*sy*dmsy*esy+dmly+ely,1.066275*sz*dmsz*esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(1.510749*sx*dmsx*psx+plx+dmlx,-1.502016*sy*dmsy*psy+ply+dmly,0.438498*sz*dmsz*psz+plz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.416577*sx*dmsx*1/esx+dmlx+elx,-1.979337*sy*dmsy*esy+dmly+ely,1.018553*sz*dmsz*1/esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(1.640760*sx*dmsx+dmlx,-0.354847*sy*dmsy+dmly,-0.116932*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx,1.494850*sy*dmsy+dmly,-0.079744*sz*dmsz+dmlz)
	me.verts.append(s)

#55
	s=NMesh.Vert(1.328437*sx*dmsx+dmlx,0.922462*sy*dmsy+dmly,-0.166161*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.161382*sx*dmsx*nhsx+nlx+dmlx,-2.466949*sy*dmsy*nhsy+nly+dmly+ncy,0.731330*sz*dmsz*nhsz+nlz+dmlz+ncz)
	me.verts.append(s)
	s=NMesh.Vert(0.243313*sx*dmsx*nhsx+nlx+dmlx,-2.317611*sy*dmsy*nhsy+nly+dmly+ncy,0.725507*sz*dmsz*nhsz+nlz+dmlz+ncz)
	me.verts.append(s)
	s=NMesh.Vert(0.351248*sx*dmsx+dmlx,-2.139369*sy*dmsy+dmly,0.727692*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx*nhsx,-2.596572*sy*dmsy*nhsy+nly+dmly+ncy,0.726249*sz*dmsz*nhsz+nlz+dmlz+ncz)
	me.verts.append(s)

#60
	s=NMesh.Vert(1.342727*sx*dbsx+dblx,-1.346723*sy*dbsy+dbly,-0.196531*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.811214*sx*dmsx*esx+dmlx+elx,-1.976979*sy*dmsy*esy+dmly+ely,0.958216*sz*dmsz*1/esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.533902*sx*dmsx*1/esx+dmlx+elx,-1.990158*sy*dmsy*esy+dmly+ely,1.076357*sz*dmsz*1/esz+dmlz+elz)
	me.verts.append(s)
	s=NMesh.Vert(0.218162*sx*dmsx*nbsx+nlx+dmlx,-2.724194*sy*dmsy*nbsy+nly+dmly,0.430730*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.296053*sx*dmsx*nbsx+nlx+dmlx,-2.565779*sy*dmsy*nbsy+nly+dmly,0.427096*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)

#65
	s=NMesh.Vert(0.370547*sx*dmsx*nbsx+nlx+dmlx,-2.245207*sy*dmsy*nbsy+nly+dmly,0.437668*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.585927*sx*dmsx*psx+plx+dmlx,-2.212472*sy*dmsy*psy+ply+dmly,0.554417*sz*dmsz*psz+plz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx*nbsx,-2.845741*sy*dmsy*nbsy+nly+dmly,0.432540*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.456822*sx*dmsx*nbsx+nlx+dmlx,-2.139501*sy*dmsy*nbsy+nly+dmly,0.264267*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.393711*sx*dmsx*nbsx+nlx+dmlx,-2.317375*sy*dmsy*nbsy+nly+dmly,0.266994*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)

#70
	s=NMesh.Vert(1.210702*sx*dbsx+dblx,-1.265453*sy*dbsy+dbly,-0.819704*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx,1.198831*sy*dbsy+dbly,-1.126513*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx*nbsx,-2.769327*sy*dmsy*nbsy+nly+dmly,0.256640*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.802931*sx*dbsx*bsx+blx+dblx,-1.917589*sy*dbsy*bsy+bly+dbly,-0.193976*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.388052*sx*dmsx*nbsx+nlx+dmlx,-2.191149*sy*dmsy*nbsy+nly+dmly,0.120226*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)

#75
	s=NMesh.Vert(0.478175*sx*dbsx+dblx,-2.132091*sy*dbsy+dbly,-0.057045*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dmsx*nbsx,-2.362204*sy*dmsy*nbsy+nly+dmly,0.116454*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.977439*sx*dbsx+dblx,-1.127100*sy*dbsy+dbly,-1.204505*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.580914*sx*dbsx*bsx+blx+dblx,-2.115908*sy*dbsy*bsy+bly+dbly,-0.311462*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.678124*sx*dbsx+dblx,-0.569686*sy*dbsy+dbly,-1.306916*sz*dbsz+dblz)
	me.verts.append(s)

#80
	s=NMesh.Vert(-0.00*sx*dbsx,-2.315732*sy*dbsy+dbly,-0.047537*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.634532*sx*dbsx*msx+mlx+dblx,-1.492145*sy*dbsy*msy+mly+mbly+dbly,-1.256285*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.550345*sx*dbsx+dblx,-0.731000*sy*dbsy+dbly,-1.381297*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.750157*sx*dbsx*msx+mlx+dblx,-1.799672*sy*dbsy*msy+mly+dbly,-0.792855*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.323577*sx*dbsx*bsx+blx+dblx,-2.300170*sy*dbsy*bsy+bly+dbly,-0.214579*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)

#85
	s=NMesh.Vert(0.553007*sx*dbsx*bsx+blx+dblx,-2.020350*sy*dbsy*bsy+bly+dbly,-0.581163*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.502847*sx*dbsx*bsx+blx+dblx,-2.084295*sy*dbsy*bsy+bly+dbly,-0.468681*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx*bsx,-2.404166*sy*dbsy*bsy+bly+dbly,-0.196428*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.532677*sx*dbsx*msx+mlx+dblx,-1.969894*sy*dbsy*msy+mly+dbly,-0.795571*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx,-0.810433*sy*dbsy+dbly,-1.420182*sz*dbsz+dblz)
	me.verts.append(s)

#90
	s=NMesh.Vert(0.340225*sx*dbsx*msx+mlx+dblx,-1.794474*sy*dbsy*msy+mly+mbly+dbly,-1.358041*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.303130*sx*dbsx*bsx+blx+dblx,-2.120960*sy*dbsy*bsy+bly+dbly,-0.655523*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx*msx,-2.119860*sy*dbsy*msy+mly+dbly,-0.801669*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx*msx,-1.953517*sy*dbsy*msy+dbly+mly+mbly,-1.358085*sz*dbsz*msz+mlz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx*bsx,-2.151931*sy*dbsy*bsy+bly+dbly,-0.671699*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)

#95
	s=NMesh.Vert(0.899915*sx*dbsx+dblx,0.788276*sy*dbsy+dbly,-1.273946*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.437420*sx*dbsx+dblx,-0.635857*sy*dbsy+dbly,-2.148860*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx,-0.852231*sy*dbsy+dbly,-2.158445*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.726100*sx*dbsx+dblx,-0.411252*sy*dbsy+dbly,-2.144511*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(1.487967*sx*dbsx+dblx,1.352687*sy*dbsy+dbly,-3.106413*sz*dbsz+dblz)
	me.verts.append(s)

#100
	s=NMesh.Vert(0.535154*sx*dbsx+dblx,-0.917752*sy*dbsy+dbly,-3.143450*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx,-1.183507*sy*dbsy+dbly,-3.113473*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.774452*sx*dbsx+dblx,-0.625950*sy*dbsy+dbly,-3.138058*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(1.209705*sx*dbsx+dblx,-0.101600*sy*dbsy+dbly,-3.130313*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.00*sx*dbsx,2.050685*sy*dbsy+dbly,-3.093356*sz*dbsz+dblz)
	me.verts.append(s)

#105
	s=NMesh.Vert(0.931020*sx*dbsx+dblx,-0.218787*sy*dbsy+dbly,-1.143632*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.320648*sx*dmsx+dmlx,-2.185531*sy*dmsy+dmly,1.529876*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(1.690832*sx*dhsx+dhlx,-0.967947*sy*dhsy+dhly,1.369674*sz*dhsz+dhlz)
	me.verts.append(s)
	s=NMesh.Vert(1.749339*sx*dmsx+dmlx,-0.255034*sy*dmsy+dmly,0.489994*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(1.389159*sx*dbsx+dblx,-0.286793*sy*dbsy+dbly,-0.617369*sz*dbsz+dblz)
	me.verts.append(s)

#110
	s=NMesh.Vert(0.972649*sx*dbsx+dblx,-0.160194*sy*dbsy+dbly,-2.204335*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(1.113705*sx*dbsx+dblx,0.809600*sy*dbsy+dbly,-2.241944*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(-0.00*sx*dbsx,1.412372*sy*dbsy+dbly,-2.206868*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(1.097328*sx*dmsx*psx+plx+dmlx,-1.960908*sy*dmsy*psy+ply+dmly,0.506964*sz*dmsz*psz+plz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.621581*sx*dhsx+dhlx,-2.037263*sy*dhsy+dhly,1.687919*sz*dhsz+dhlz)
	me.verts.append(s)

#115
	s=NMesh.Vert(0.738757*sx*dmsx+dmlx,-2.076714*sy*dmsy+dmly,0.138215*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.776544*sx*dbsx*bsx+blx+dblx,-1.858630*sy*dbsy*bsy+bly+dbly,-0.493415*sz*dbsz*bsz+blz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.973494*sx*dmsx+dmlx,-2.009887*sy*dmsy+dmly,1.501422*sz*dmsz+dmlz)
	me.verts.append(s)
	s=NMesh.Vert(0.238323*sx*dbsx+dblx,-2.223912*sy*dbsy+dbly,-0.052291*sz*dbsz+dblz)
	me.verts.append(s)
	s=NMesh.Vert(0.196090*sx*dmsx*nbsx+nlx+dmlx,-2.588790*sy*dmsy*nbsy+nly+dmly,0.261831*sz*dmsz*nbsz+nlz+dmlz)
	me.verts.append(s)


# --- 2 --- Creation des faces

#5
	f=NMesh.Face()
	f.v.append(me.verts[8])
	f.v.append(me.verts[9])
	f.v.append(me.verts[89])
	f.v.append(me.verts[86])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[6])
	f.v.append(me.verts[10])
	f.v.append(me.verts[9])
	f.v.append(me.verts[8])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[8])
	f.v.append(me.verts[86])
	f.v.append(me.verts[80])
	f.v.append(me.verts[81])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[4])
	f.v.append(me.verts[6])
	f.v.append(me.verts[8])
	f.v.append(me.verts[81])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[5])
	f.v.append(me.verts[79])
	f.v.append(me.verts[82])
	f.v.append(me.verts[7])
	me.faces.append(f)

#10
	f=NMesh.Face()
	f.v.append(me.verts[3])
	f.v.append(me.verts[73])
	f.v.append(me.verts[79])
	f.v.append(me.verts[5])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[51])
	f.v.append(me.verts[54])
	f.v.append(me.verts[62])
	f.v.append(me.verts[58])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[51])
	f.v.append(me.verts[58])
	f.v.append(me.verts[59])
	f.v.append(me.verts[52])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[52])
	f.v.append(me.verts[59])
	f.v.append(me.verts[60])
	f.v.append(me.verts[53])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[33])
	f.v.append(me.verts[43])
	f.v.append(me.verts[44])
	f.v.append(me.verts[34])
	me.faces.append(f)

#15
	f=NMesh.Face()
	f.v.append(me.verts[35])
	f.v.append(me.verts[40])
	f.v.append(me.verts[41])
	f.v.append(me.verts[36])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[15])
	f.v.append(me.verts[20])
	f.v.append(me.verts[21])
	f.v.append(me.verts[17])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[20])
	f.v.append(me.verts[25])
	f.v.append(me.verts[27])
	f.v.append(me.verts[21])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[25])
	f.v.append(me.verts[32])
	f.v.append(me.verts[37])
	f.v.append(me.verts[27])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[32])
	f.v.append(me.verts[50])
	f.v.append(me.verts[49])
	f.v.append(me.verts[37])
	me.faces.append(f)

#20
	f=NMesh.Face()
	f.v.append(me.verts[49])
	f.v.append(me.verts[50])
	f.v.append(me.verts[90])
	f.v.append(me.verts[66])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[11])
	f.v.append(me.verts[15])
	f.v.append(me.verts[17])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[14])
	f.v.append(me.verts[19])
	f.v.append(me.verts[20])
	f.v.append(me.verts[15])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[19])
	f.v.append(me.verts[23])
	f.v.append(me.verts[25])
	f.v.append(me.verts[20])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[23])
	f.v.append(me.verts[31])
	f.v.append(me.verts[32])
	f.v.append(me.verts[25])
	me.faces.append(f)

#25
	f=NMesh.Face()
	f.v.append(me.verts[31])
	f.v.append(me.verts[103])
	f.v.append(me.verts[32])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[13])
	f.v.append(me.verts[16])
	f.v.append(me.verts[19])
	f.v.append(me.verts[14])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[16])
	f.v.append(me.verts[22])
	f.v.append(me.verts[23])
	f.v.append(me.verts[19])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[102])
	f.v.append(me.verts[22])
	f.v.append(me.verts[26])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[26])
	f.v.append(me.verts[30])
	f.v.append(me.verts[39])
	f.v.append(me.verts[102])
	me.faces.append(f)

#30
	f=NMesh.Face()
	f.v.append(me.verts[31])
	f.v.append(me.verts[102])
	f.v.append(me.verts[39])
	f.v.append(me.verts[103])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[39])
	f.v.append(me.verts[46])
	f.v.append(me.verts[48])
	f.v.append(me.verts[103])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[104])
	f.v.append(me.verts[100])
	f.v.append(me.verts[90])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[46])
	f.v.append(me.verts[55])
	f.v.append(me.verts[104])
	f.v.append(me.verts[48])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[65])
	f.v.append(me.verts[72])
	f.v.append(me.verts[100])
	f.v.append(me.verts[104])
	me.faces.append(f)

#35
	f=NMesh.Face()
	f.v.append(me.verts[55])
	f.v.append(me.verts[65])
	f.v.append(me.verts[104])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[12])
	f.v.append(me.verts[18])
	f.v.append(me.verts[16])
	f.v.append(me.verts[13])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[16])
	f.v.append(me.verts[18])
	f.v.append(me.verts[24])
	f.v.append(me.verts[22])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[11])
	f.v.append(me.verts[12])
	f.v.append(me.verts[13])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[11])
	f.v.append(me.verts[13])
	f.v.append(me.verts[14])
	f.v.append(me.verts[15])
	me.faces.append(f)

#40
	f=NMesh.Face()
	f.v.append(me.verts[83])
	f.v.append(me.verts[87])
	f.v.append(me.verts[88])
	f.v.append(me.verts[85])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[77])
	f.v.append(me.verts[85])
	f.v.append(me.verts[88])
	f.v.append(me.verts[84])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[65])
	f.v.append(me.verts[78])
	f.v.append(me.verts[76])
	f.v.append(me.verts[72])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[77])
	f.v.append(me.verts[84])
	f.v.append(me.verts[92])
	f.v.append(me.verts[91])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[91])
	f.v.append(me.verts[92])
	f.v.append(me.verts[96])
	f.v.append(me.verts[95])
	me.faces.append(f)

#45
	f=NMesh.Face()
	f.v.append(me.verts[90])
	f.v.append(me.verts[100])
	f.v.append(me.verts[105])
	f.v.append(me.verts[106])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[94])
	f.v.append(me.verts[106])
	f.v.append(me.verts[105])
	f.v.append(me.verts[98])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[66])
	f.v.append(me.verts[90])
	f.v.append(me.verts[106])
	f.v.append(me.verts[107])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[94])
	f.v.append(me.verts[99])
	f.v.append(me.verts[107])
	f.v.append(me.verts[106])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[93])
	f.v.append(me.verts[97])
	f.v.append(me.verts[98])
	f.v.append(me.verts[105])
	me.faces.append(f)

#50
	f=NMesh.Face()
	f.v.append(me.verts[91])
	f.v.append(me.verts[95])
	f.v.append(me.verts[97])
	f.v.append(me.verts[93])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[74])
	f.v.append(me.verts[77])
	f.v.append(me.verts[91])
	f.v.append(me.verts[93])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[76])
	f.v.append(me.verts[78])
	f.v.append(me.verts[83])
	f.v.append(me.verts[85])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[72])
	f.v.append(me.verts[76])
	f.v.append(me.verts[85])
	f.v.append(me.verts[77])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[72])
	f.v.append(me.verts[77])
	f.v.append(me.verts[74])
	f.v.append(me.verts[100])
	me.faces.append(f)

#55
	f=NMesh.Face()
	f.v.append(me.verts[74])
	f.v.append(me.verts[93])
	f.v.append(me.verts[105])
	f.v.append(me.verts[100])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[39])
	f.v.append(me.verts[45])
	f.v.append(me.verts[108])
	f.v.append(me.verts[46])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[45])
	f.v.append(me.verts[56])
	f.v.append(me.verts[61])
	f.v.append(me.verts[108])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[28])
	f.v.append(me.verts[38])
	f.v.append(me.verts[33])
	f.v.append(me.verts[101])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[28])
	f.v.append(me.verts[101])
	f.v.append(me.verts[29])
	f.v.append(me.verts[109])
	me.faces.append(f)

#60
	f=NMesh.Face()
	f.v.append(me.verts[33])
	f.v.append(me.verts[38])
	f.v.append(me.verts[54])
	f.v.append(me.verts[51])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[33])
	f.v.append(me.verts[51])
	f.v.append(me.verts[52])
	f.v.append(me.verts[43])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[43])
	f.v.append(me.verts[52])
	f.v.append(me.verts[53])
	f.v.append(me.verts[47])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[86])
	f.v.append(me.verts[89])
	f.v.append(me.verts[87])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[80])
	f.v.append(me.verts[86])
	f.v.append(me.verts[87])
	f.v.append(me.verts[83])
	me.faces.append(f)

#65
	f=NMesh.Face()
	f.v.append(me.verts[110])
	f.v.append(me.verts[108])
	f.v.append(me.verts[61])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[61])
	f.v.append(me.verts[63])
	f.v.append(me.verts[70])
	f.v.append(me.verts[110])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[63])
	f.v.append(me.verts[64])
	f.v.append(me.verts[69])
	f.v.append(me.verts[70])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[2])
	f.v.append(me.verts[81])
	f.v.append(me.verts[80])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[2])
	f.v.append(me.verts[73])
	f.v.append(me.verts[3])
	me.faces.append(f)

#70
	f=NMesh.Face()
	f.v.append(me.verts[2])
	f.v.append(me.verts[4])
	f.v.append(me.verts[81])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[111])
	f.v.append(me.verts[55])
	f.v.append(me.verts[68])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[78])
	f.v.append(me.verts[111])
	f.v.append(me.verts[80])
	f.v.append(me.verts[83])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[2])
	f.v.append(me.verts[80])
	f.v.append(me.verts[111])
	f.v.append(me.verts[68])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[34])
	f.v.append(me.verts[44])
	f.v.append(me.verts[40])
	f.v.append(me.verts[35])
	me.faces.append(f)

#75
	f=NMesh.Face()
	f.v.append(me.verts[1])
	f.v.append(me.verts[57])
	f.v.append(me.verts[47])
	f.v.append(me.verts[56])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[43])
	f.v.append(me.verts[44])
	f.v.append(me.verts[57])
	f.v.append(me.verts[47])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[0])
	f.v.append(me.verts[42])
	f.v.append(me.verts[36])
	f.v.append(me.verts[41])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[29])
	f.v.append(me.verts[101])
	f.v.append(me.verts[34])
	f.v.append(me.verts[35])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[33])
	f.v.append(me.verts[101])
	f.v.append(me.verts[34])
	me.faces.append(f)

#80
	f=NMesh.Face()
	f.v.append(me.verts[112])
	f.v.append(me.verts[30])
	f.v.append(me.verts[26])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[29])
	f.v.append(me.verts[112])
	f.v.append(me.verts[36])
	f.v.append(me.verts[35])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[30])
	f.v.append(me.verts[112])
	f.v.append(me.verts[36])
	f.v.append(me.verts[42])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[0])
	f.v.append(me.verts[1])
	f.v.append(me.verts[56])
	f.v.append(me.verts[45])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[30])
	f.v.append(me.verts[42])
	f.v.append(me.verts[39])
	me.faces.append(f)

#85
	f=NMesh.Face()
	f.v.append(me.verts[0])
	f.v.append(me.verts[45])
	f.v.append(me.verts[39])
	f.v.append(me.verts[42])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[32])
	f.v.append(me.verts[103])
	f.v.append(me.verts[48])
	f.v.append(me.verts[50])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[48])
	f.v.append(me.verts[104])
	f.v.append(me.verts[90])
	f.v.append(me.verts[50])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[55])
	f.v.append(me.verts[111])
	f.v.append(me.verts[78])
	f.v.append(me.verts[65])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[2])
	f.v.append(me.verts[68])
	f.v.append(me.verts[70])
	f.v.append(me.verts[73])
	me.faces.append(f)

#90
	f=NMesh.Face()
	f.v.append(me.verts[68])
	f.v.append(me.verts[108])
	f.v.append(me.verts[110])
	f.v.append(me.verts[70])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[46])
	f.v.append(me.verts[108])
	f.v.append(me.verts[68])
	f.v.append(me.verts[55])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[69])
	f.v.append(me.verts[70])
	f.v.append(me.verts[113])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[75])
	f.v.append(me.verts[82])
	f.v.append(me.verts[79])
	f.v.append(me.verts[113])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[70])
	f.v.append(me.verts[113])
	f.v.append(me.verts[79])
	f.v.append(me.verts[73])
	me.faces.append(f)

#95
	f=NMesh.Face()
	f.v.append(me.verts[53])
	f.v.append(me.verts[60])
	f.v.append(me.verts[63])
	f.v.append(me.verts[61])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[47])
	f.v.append(me.verts[53])
	f.v.append(me.verts[61])
	f.v.append(me.verts[56])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[64])
	f.v.append(me.verts[114])
	f.v.append(me.verts[69])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[58])
	f.v.append(me.verts[62])
	f.v.append(me.verts[67])
	f.v.append(me.verts[114])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[58])
	f.v.append(me.verts[114])
	f.v.append(me.verts[64])
	f.v.append(me.verts[59])
	me.faces.append(f)

#100
	f=NMesh.Face()
	f.v.append(me.verts[59])
	f.v.append(me.verts[64])
	f.v.append(me.verts[63])
	f.v.append(me.verts[60])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[69])
	f.v.append(me.verts[113])
	f.v.append(me.verts[75])
	f.v.append(me.verts[71])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[67])
	f.v.append(me.verts[114])
	f.v.append(me.verts[69])
	f.v.append(me.verts[71])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[26])
	f.v.append(me.verts[109])
	f.v.append(me.verts[29])
	f.v.append(me.verts[112])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[22])
	f.v.append(me.verts[102])
	f.v.append(me.verts[31])
	f.v.append(me.verts[23])
	me.faces.append(f)

#103
	f=NMesh.Face()
	f.v.append(me.verts[22])
	f.v.append(me.verts[24])
	f.v.append(me.verts[109])
	f.v.append(me.verts[26])
	me.faces.append(f)
	f=NMesh.Face()
	f.v.append(me.verts[24])
	f.v.append(me.verts[28])
	f.v.append(me.verts[109])
	me.faces.append(f)
	#f=NMesh.Face()
	#f.v.append(me.verts[14])
	#f.v.append(me.verts[11])
	#me.faces.append(f)


# --- 3 --- Demande a Blender de dessiner le mesh "nom"
	NMesh.PutRaw(me,nom,1)
	Blender.Redraw()

# ---------------------------------
#		Fin du script,
# Supprimer tout ce qui pourrait 
#  apparaitre apres cette ligne
#
###########################################################