/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick3D
import Outrun_Cluster 1.0
import QtQuick.Timeline 1.0

DirectionalLight {
    property bool night: false
    id: lightDirectional
    visible: true
    eulerRotation.y: 179.99995
    eulerRotation.x: -76.49341
    eulerRotation.z: -179.99997
    color: "#ffffff"
    states: [
        State {
            name: "day"
            when: night == false

            PropertyChanges {
                target: lightDirectional
                color: "#fff0e0"
                ambientColor: "#000000"
                brightness: 5
                eulerRotation.y: 179.99995
                eulerRotation.x: -35
                eulerRotation.z: -179.99997
            }
        },
        State {
            name: "night"
            when: night == true

            PropertyChanges {}

            PropertyChanges {
                target: lightDirectional
                color: "#dec9ff"
                ambientColor: "#000000"
                brightness: 10
                eulerRotation.y: 179.99998
                eulerRotation.x: -13.56979
                eulerRotation.z: -180
            }
        }
    ]
    transitions: [
        Transition {
            id: transition
            ParallelAnimation {



                    PropertyAnimation {
                        target: lightDirectional
                        property: "brightness"
                        duration: 1000
                    }

                    PropertyAnimation {
                        target: lightDirectional
                        property: "eulerRotation.x"
                        duration: 1000
                    }


                    PropertyAnimation {
                        target: lightDirectional
                        property: "ambientColor"
                        duration: 1000
                    }
                }
            to: "*"
            from: "*"
        }
    ]
    ambientColor: "#000000"
    brightness: 2

}
