import QtQuick
import QtQuick.Controls

Rectangle {
    id: root

    property alias titleText: panelTitle.text
    property alias panelTitleHeight: panelTitle.height

    width: parent.width
    height: parent.height - panelTitle.height
    color: "transparent"
    border.width: 4
    border.color: "#42ffffff"
    radius: 15

    Text {
        id: panelTitle

        anchors.bottom: parent.top
        anchors.left: parent.left
        anchors.leftMargin: 10
        text: "title"
        color: "#ffffff"
        font.pixelSize: parent.width / 10
        font.styleName: "Regular"
        font.family: "Titillium Web"
    }
}
