/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QTCOREHELPER_H
#define QTCOREHELPER_H

#include <QtCore/qmutex.h>

namespace QtCoreHelper {

    using MutexLocker = QT_PREPEND_NAMESPACE(QMutexLocker<QMutex>);
    using RecursiveMutexLocker = QT_PREPEND_NAMESPACE(QMutexLocker<QRecursiveMutex>);

    // ::QMutexLocker is a template with the QMutex class as parameter which can
    // only be represented by different type names in Python. Provide a common API.
    class QMutexLocker
    {
    public:
        Q_DISABLE_COPY_MOVE(QMutexLocker)

        explicit QMutexLocker(QMutex *m)
            : m_mutexLocker(new MutexLocker(m))
        {
        }

        explicit QMutexLocker(QRecursiveMutex *m)
            : m_recursiveMutexLocker(new RecursiveMutexLocker(m))
        {
        }

        void unlock()
        {
            if (m_mutexLocker)
                m_mutexLocker->unlock();
            else
                m_recursiveMutexLocker->unlock();
        }

        void relock()
        {
            if (m_mutexLocker)
                m_mutexLocker->relock();
            else
                m_recursiveMutexLocker->relock();
        }

        QMutex *mutex() const
        {
            return m_mutexLocker ? m_mutexLocker->mutex() : nullptr;
        }

        QRecursiveMutex *recursiveMutex() const
        {
            return m_recursiveMutexLocker ? m_recursiveMutexLocker->mutex() : nullptr;
        }

        ~QMutexLocker()
        {
            delete m_mutexLocker;
            delete m_recursiveMutexLocker;
        }

    private:
        MutexLocker *m_mutexLocker = nullptr;
        RecursiveMutexLocker *m_recursiveMutexLocker = nullptr;
    };

} // namespace QtCoreHelper

#endif // QTCOREHELPER_H
